/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SimpleProgressMonitor.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.tools.internal;

/**
 * This class provides a progress monitor which do nothing
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SimpleProgressMonitor implements IDProgressMonitor {

    private boolean inprogress;
    private boolean canceled;
    private int     nuwork;
    private int     nbwork;
    private String  taskName;
    

    public void beginTask(String name, int total_works) {
        taskName = name;
        inprogress = true;
        nbwork = total_works;
        nuwork = 0;
    }


    public void done() {
        inprogress = false;
    }

 
    public boolean isCanceled() {
         return canceled;
    }


    public void setCanceled(boolean value) {
       inprogress = false;
       canceled = value;
    }

  
    public void worked(int work) {
       nuwork = work;
    }

    

    public int getWorkCount() {
        return nuwork;
    }


    public void setTotalWorks(int tw) {
         nbwork=tw;
    }


    public int getTotalWorks() {
         return nbwork;
    }

    public boolean isInProgress() {
        return inprogress;
    }


    public String getTaskName() {
        return taskName;
    }

}
