/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VFloat.java,v 1.3 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 3 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;

/**
 * A float known as an Object, but value can be changed (not the case of java.lang.Float).
 * As VFloat is a VNumber, is a Number too...
 * Use this at your convenience.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class VFloat extends VNumber
{
  /**
     * 
     */
    private static final long serialVersionUID = 1L;
protected float value_;
  
  /** Create a Float object with 0.0f value */
  public VFloat()
  {
    value_=0.0f;
  }
  
  /** Create a Float object with a value */
  public VFloat( float _value )
  {
    value_ = _value;
  }
  
  public String toString()
  {
    return Float.toString(value_);
  }
  
  public VNumber setValue( Object _value )
  {
    if( _value instanceof Number ) value_ = ((Number)_value).floatValue();
    return this;
  }
  
  public float  floatValue() { return value_; }
  public double doubleValue(){ return value_; }
  public long   longValue()  { return (long)value_; }
  public int    intValue()   { return (int)value_; }
  public short  shortValue() { return (short)value_; }
  public byte   byteValue()  { return (byte)value_; }
  
  public VNumber setValue( byte   _value ) { value_ = _value; return this; }
  public VNumber setValue( double _value ) { value_ = (float)_value; return this;}
  public VNumber setValue( float  _value ) { value_ = _value; return this; }
  public VNumber setValue( int    _value ) { value_ = _value; return this; }
  public VNumber setValue( long   _value ) { value_ = _value; return this; }
  public VNumber setValue( short  _value ) { value_ = _value; return this; }

  public int compareTo( Object o )
  {
    //might throw ClassCastException as compareTo help said..
    return Float.compare( value_, ((Number)o).floatValue() );
  }
  
}
