/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VLong.java,v 1.3 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 8 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;


/**
 * A long known as an Object, but value can be changed (not the case of java.lang.Long).
 * Use this class at your convenience.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class VLong extends VNumber
{
  /**
     * 
     */
    private static final long serialVersionUID = 1L;
protected long value_;
  
  /** Create a Long object with 0 value */
  public VLong()
  {
    value_=0;
  }
  
  /** Create a Long object with a value */
  public VLong( long _value )
  {
    value_ = _value;
  }
  
  public float  floatValue() { return value_; }
  public double doubleValue(){ return value_; }
  public long   longValue()  { return value_; }
  public int    intValue()   { return (int)value_; }
  public short  shortValue() { return (short)value_; }
  public byte   byteValue()  { return (byte)value_; }
  
  public VNumber setValue( byte   _value ) { value_ = _value; return this; }
  public VNumber setValue( double _value ) { value_ = (long)_value; return this;}
  public VNumber setValue( float  _value ) { value_ = (long)_value; return this; }
  public VNumber setValue( int    _value ) { value_ = _value; return this; }
  public VNumber setValue( long   _value ) { value_ = _value; return this; }
  public VNumber setValue( short  _value ) { value_ = _value; return this; }
  
  public VNumber setValue( Object _value )
  {
    if( _value instanceof Number )
    {
      value_ = ((Number)_value).longValue();
    }
    return this;
  }
  
  public String toString()
  {
    return Long.toString(value_);
  }
  
  public int compareTo( Object o )
  {
    //might throw ClassCastException as compareTo help said..
    return (int)( value_ - ((Number)o).longValue() );
  }
}
