/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: VNumber.java,v 1.2 2008/05/23 14:11:52 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 7 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.tools.internal;

/**
 * VNumber is a Number with modifiable value.
 * Don't ask me why java.lang.Float,Byte,... implements Comparable but java.lang.Number not.
 * 
 * @see VFloat
 * @see VLong
 * @author ademuyser
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class VNumber extends Number implements Comparable
{
  /** change value of number using a byte */
  public abstract VNumber setValue( byte value ) ;
  /** change value of number using a double */
  public abstract VNumber setValue( double value );
  /** change value of number using a float */
  public abstract VNumber setValue( float value);
  /** change value of number using an integer */
  public abstract VNumber setValue( int value );
  /** change value of number using a long value */
  public abstract VNumber setValue( long value );
  /** change value of number using a short value */
  public abstract VNumber setValue( short value );  

  /**
   * Change stored value if object is from a known class.
   * Known class can be java.lang.Number, or VNumber, or anything VNumber's implementors
   * think interesting.
   */
  public abstract VNumber setValue( Object value );
}
