/**********************************************************************
Copyright (c) 2005, 2006 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: SetConfig.java,v 1.10 2006/09/06 18:32:41 cjin Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.logging.core;

import java.io.File;
import java.util.Enumeration;

import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.FileFilterImpl;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {

	public void askUser() {
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element aEnv;
		Element option;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);
		PluginConfig.setRequires(pConfig, "org.eclipse.hyades.execution, org.eclipse.tptp.platform.logging.events");
 
		//
		// Provides
		//
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hl14.jar");
		aEnv.appendChild(var);
		
		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hlcommons.jar");
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hlcore.jar");
		aEnv.appendChild(var);
		
		
		

	/**	
	 * var = doc.createElement(Variable.TAG);
	 *	Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");
	 *	Variable.setPosition(var, "append");
	 *	Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hlevents.jar");
	 *	aEnv.appendChild(var); 
	 **/

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");
		Variable.setPosition(var, "append");
		Variable.setValue(var, "%PLUGINS_HOME%" + sr + getPluginName() + sr + "hllog4j.jar");
		aEnv.appendChild(var);

        //Add all of the NL jars to the classpath:
        Enumeration nlJars = getNLFiles();
        
        while(nlJars.hasMoreElements()) {
            
            var = doc.createElement(Variable.TAG);            
            Variable.setName(var, "CLASSPATH_ORG_ECLIPSE_HYADES_LOGGING_CORE");            
            Variable.setPosition(var, "append");            
            Variable.setValue(var, ((String)(nlJars.nextElement())));            
            aEnv.appendChild(var);
        }
      	
		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setType(option, "version");
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(option, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(option, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(option, getPluginName());
			Option.setValue(option, "unknown");
		}
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

/*	public String resolveClasspath(String path, String pluginAlias, boolean flag) {
		if(path != null) {
			File pluginDir = new File(path);
			if(pluginDir.exists() && pluginDir.isDirectory()) {
				File[] plugins;

				if (flag){
					plugins = pluginDir.listFiles(new FileFilterImpl("^" + pluginAlias + "_[0-9].*"));
				} else {
					plugins = pluginDir.listFiles(new FileFilterImpl("^" + pluginAlias + ".*")); // Take care of the version as wel
				}

				if (plugins.length > 0)
					return plugins[0].getAbsolutePath();
			}
		}
		return pluginAlias;
	}*/
	public void printHelp() {
	}

	public void printExamples() {
	}
	
	
}