package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IPreemptedLogger.java,v 1.4 2006/02/03 20:50:29 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Interface for controller and polling a Logging Agent instance 
 * running in the Agent Controller.
 * <p>
 * Loggers or Logging Agent extension instances that implement this 
 * interface provide the following function:
 * <p>
 * <ul>
 * <li>Suspend the Logging Agent until the Logging Agent is monitored to a maximum time 
 * (milliseconds).</li>
 * <li>Check for if the Logging Agent is being monitored</li>
 * <li>De-registration of the Logging Agent instance from the Agent Controller</li>
 * </ul>
 * <p>
 * 
 * @author  Paul E. Slauenwhite
 * @version February 3, 2006
 * @since   January 26, 2005
 */
public interface IPreemptedLogger {
	
	/**
	 * Suspends the current thread until the Logging Agent is monitored or the 
	 * the parameter maximum time (milliseconds) has expired.
	 *
	 * @param maxTime the maximum amount of time (milliseconds) to suspend the current thread
	 * @return true if the logger is being monitored
	 */
	public boolean waitUntilLogging(long maxTime);

	/**
	 * Checks if the Logging Agent is logging (e.g. Agent Controller is available and the Logging Agent is being monitored).
	 *
	 * @return True if the Logging Agent is logging, otherwise false.
	 */
	public boolean isLogging();
	
	/**
	 * Deregisters this Logging Agent instance from the Agent Controller.
	 */
	public void finalize();
}