package org.eclipse.hyades.logging.core;
/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoggingAgentCustomCommand.java,v 1.2 2008/01/24 02:26:07 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
import java.io.UnsupportedEncodingException;

/**
 * This is a wrapper class that provides service to build custom command.
 * 
 * @author CindyJ
 * @auther Paul E.Slauenwhite
 * @since September 6,2006
 *
 */
public class LoggingAgentCustomCommand {

	protected String data = null;
	
	public LoggingAgentCustomCommand(String data){	
		this.data = data;
	}
	/**
	 * Get command string.
	 * @return The command string.
	 */
	public String getData() {
		return data;
	}

	/**
	 * Get command in byte array.
	 * @return the byte array.
	 */
	public byte[] getDataBinary() {
		
		if(data != null){
			
			try {
				return (data.getBytes("UTF-8"));
			} 
			catch(UnsupportedEncodingException u){
				//Ignore and return 'null'.
			}
		}
		
		return null;
	}
}
