package org.eclipse.hyades.logging.core;
/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoggingAgentMonitorListener.java,v 1.1 2006/09/08 04:10:00 cjin Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
/**
 * Interface provides service to custom monitor listener.   
 * <p>
 * <code> LoggingAgent</code> provides function to register the 
 * <code>LoggingAgentMonitorListener</code> instance as monitor listener 
 * to Agent controller
 * </p>
 * implementation of this interface provide the following function:
 * <p>
 * <ul>
 * <li>handles logger is turned on </li>
 * <li>handles logger is turned on</li>
 *  </ul>
 * <p>
 * @author CindyJ
 * @auther Paul E.Slauenwhite
 * @since September 6,2006
 *
 */
public interface LoggingAgentMonitorListener {
	
	/**
	 * The logger is truned on.
	 */
	public void loggingAgentMonitorActive();
	/**
	 * The logger is truned off.
	 */
     public void loggingAgentMonitorInactive(); 
}
