/***********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PDPerspective.java,v 1.12 2008/05/29 02:13:55 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.ui.*;
import org.eclipse.ui.console.*;
import org.eclipse.debug.ui.*;

public class PDPerspective implements IPerspectiveFactory
{
   public static final String ID_TRACE_PERSPECTIVE = "org.eclipse.hyades.trace.internal.ui.tracePerspective";
   public static final String ID_PD_NAVIGATOR_VIEW   = "org.eclipse.hyades.trace.internal.ui.PDProjectExplorer";
   //public static final String ID_CONSOLE_VIEW= "org.eclipse.hyades.trace.ui.internal.console.TraceConsoleView";
   public static final String ID_CONSOLE_VIEW= IConsoleConstants.ID_CONSOLE_VIEW;
   public static final String ID_LOG_NAVIGATOR_VIEW = "org.eclipse.hyades.log.ui.internal.navigator.LogNavigator";
   public static final String ID_EXEC_STATS = "org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer2";
   
   // ID_EXEC_STATS was added for bugzilla_153455 to add a permanent placeholder
    // which serves as a relative view for the views which used to be related to the
    // console view but now have been separated. Could add any view as a placeholder here.
   
   public void createInitialLayout(IPageLayout layout)
	{	
		//Top right
		IFolderLayout topRight = layout.createFolder("topRight", IPageLayout.TOP, (float)0.75,
			layout.getEditorArea());
		topRight.addPlaceholder(ID_EXEC_STATS);
		
		// Top left.
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, (float)0.25,
			"topRight");
		topLeft.addView(ID_PD_NAVIGATOR_VIEW);		
		topLeft.addView(IPageLayout.ID_RES_NAV);

		
		// Bottom Left
		// Modified for bugzilla_153455, to move the console
		// view to the bottom right so it no longer 
		// blocks the Profiling Views, also helps for log file
		// properties view
		// Liz Dancy
		
		
		
		IPlaceholderFolderLayout bottomRight = layout.createPlaceholderFolder("bottomRight", IPageLayout.BOTTOM, (float)0.70,
				"topRight");
		bottomRight.addPlaceholder(IPageLayout.ID_TASK_LIST);
		bottomRight.addPlaceholder(IPageLayout.ID_PROBLEM_VIEW);	
		bottomRight.addPlaceholder(IPageLayout.ID_PROP_SHEET);		
		bottomRight.addPlaceholder(ID_CONSOLE_VIEW);
		layout.addShowViewShortcut(ID_PD_NAVIGATOR_VIEW);												
		layout.addShowViewShortcut(ID_CONSOLE_VIEW);
		layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);	
		layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
		layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
					
		//new actions
		layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
		
		layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
		

		layout.setEditorAreaVisible(false);
	}
}
