/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PDProjectViewer.java,v 1.11 2008/03/17 07:35:42 ialelekov Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID trce0000 for Monitors (trace projects) view
 */

public class PDProjectViewer extends TreeViewer {

	public PDProjectViewer(Composite parent) {
		super(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(),
				UIPlugin.getPluginId() + ".trce0000");

	}

	public void createSelectedNodeChildren() {
		Tree _tree = (Tree) getControl();
		Item[] sels = getSelection(_tree);
		if (sels != null)
			super.createChildren(sels[0]);

	}

	public IResource getSelectionFolder() {
		return getSelectionFolder(getTreeSelection());

	}

	protected IResource getSelectionFolder(TreeItem selection) {
		if (selection != null && selection.getData() != null) {
			Object data = selection.getData();
			if (data instanceof IResource)
				return (IResource) data;

			if (data instanceof EObject) {
				String strPath = TString.resourcePath(((EObject) data)
						.eResource().getURI());
				return UIPlugin.getPluginWorkbench().getRoot().findMember(
						(new Path(strPath)).removeLastSegments(1));
			}
		}

		return null;
	}

	public IProject getSelectionProject() {
		TreeItem selection = getTreeSelection();

		if (selection != null && selection.getData() != null) {
			Object data = selection.getData();
			if (data instanceof IProject)
				return (IProject) data;

			while (data instanceof INavigatorItem) {
				data = ((INavigatorItem) data).getParent();
			}

			if (data instanceof EObject) {
				String strPath = TString.resourcePath(EcoreUtil.getURI((EObject) data));
				return (IProject) UIPlugin.getPluginWorkbench().getRoot()
						.findMember((new Path(strPath)).uptoSegment(1));
			}
		}

		return null;
	}

	public TRCMonitor getSelectionMonitor() {
		TreeItem selection = getTreeSelection();

		while (selection != null) {
			if (selection.getData() != null
					&& selection.getData() instanceof TRCAgentProxy)
				return ((TRCAgentProxy) selection.getData()).getProcessProxy()
						.getNode().getMonitor();
			if (selection.getData() != null
					&& selection.getData() instanceof TRCProcessProxy)
				return ((TRCProcessProxy) selection.getData()).getNode()
						.getMonitor();
			if (selection.getData() != null
					&& selection.getData() instanceof TRCNode)
				return ((TRCNode) selection.getData()).getMonitor();
			if (selection.getData() != null
					&& selection.getData() instanceof TRCMonitor)
				return (TRCMonitor) selection.getData();

			selection = selection.getParentItem();
		}

		return null;
	}

	public TreeItem getTreeSelection() {
		Item[] sels = getTreeSelections();
		return (sels != null && sels.length > 0) ? (TreeItem) sels[0] : null;
	}

	public Item[] getTreeSelections() {
		Control c = getControl();
		if (c.isDisposed()) return null;

		Item[] sels = getSelection(c);
		if (sels.length > 0)
			return sels;

		return null;
	}

	/**
	 * Insert the method's description here. Creation date: (09/26/2000 12:35:46
	 * PM)
	 * 
	 * @param obj
	 *            java.lang.Object
	 */
	public void selectObject(final Object item) 
	{
		if (item == null)
			return;
		
		UIPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable()
		{
			public void run()
			{
				IWorkspaceRoot root = UIPlugin.getPluginWorkbench().getRoot();
				try
				{
					refresh();
				}
				catch (Exception exc) 
				{
					UIPlugin.getDefault().log(exc);
				}
				if (item instanceof TRCMonitor) 
				{
					TRCMonitor mon = (TRCMonitor) item;
					String path = TString.resourcePath(mon.eResource().getURI());
					if (path != null) 
					{
						path = path.substring(0, path.length()
								- (new Path(path)).lastSegment().length());

						IResource res = root.findMember(path);
						if (path != null)
							setExpandedState(res, true);
					}

					select(mon);
				} 
				else if (item instanceof TRCNode) 
				{
					TRCNode node = (TRCNode) item;
					String path = TString.resourcePath(node.eResource().getURI());
					if (path != null) 
					{
						path = path.substring(0, path.length()
								- (new Path(path)).lastSegment().length());

						IResource res = root.findMember(path);
						if (path != null)
							setExpandedState(res, true);
					}

					setExpandedState(node.getMonitor(), true);
					select(node);
				} 
				else if (item instanceof TRCProcessProxy) 
				{
					TRCProcessProxy prc = (TRCProcessProxy) item;
					String path = TString.resourcePath(prc.eResource().getURI());
					if (path != null) 
					{
						path = path.substring(0, path.length()
								- (new Path(path)).lastSegment().length());

						IResource res = root.findMember(path);
						if (path != null)
							setExpandedState(res, true);
					}

					setExpandedState(prc.getNode().getMonitor(), true);
					setExpandedState(prc.getNode(), true);
					select(prc);
				} 
				else if (item instanceof TRCAgentProxy) 
				{
					TRCAgentProxy agent = (TRCAgentProxy) item;
					String path = TString.resourcePath(agent.eResource().getURI());
					if (path != null) 
					{
						path = path.substring(0, path.length()
								- (new Path(path)).lastSegment().length());

						IResource res = root.findMember(path);
						if (path != null && res !=null)
							setExpandedState(res, true);
					}

					setExpandedState(agent.getProcessProxy().getNode().getMonitor(),
							true);
					setExpandedState(agent.getProcessProxy().getNode(), true);
					setExpandedState(agent.getProcessProxy(), true);
					select(agent);
				} 
				else if (item instanceof INavigatorItem) 
				{
					INavigatorItem navigatorItem = (INavigatorItem) item;

					select(navigatorItem);
				}
			}
		});			
	}

	private void select(Object item) 
	{
		if (item == null)
			return;

		Widget treeItem = doFindItem(item);

		if (treeItem == null || !(treeItem instanceof TreeItem))
			return;

		setSelection(new StructuredSelection(item), true);

		Tree _tree = (Tree) getControl();

		Item currentSelection = null;
		if (_tree.getSelectionCount() > 0) {
			currentSelection = _tree.getSelection()[0];
			internalExpandToLevel(currentSelection, 1);
		} else {
			TreeItem[] items = _tree.getItems();
			if (items.length > 0) {
				internalExpandToLevel(items[0], 1);
			}
		}
	}

	public void dispose() {
	}
}
