/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceUIManager.java,v 1.15 2007/12/01 00:36:15 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

/**
 * @author popescu
 * 
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TraceUIManager extends org.eclipse.tptp.platform.common.ui.trace.internal.TraceUIManager
{
	/**
	 * @param process
	 */
	public static void deregisterLaunchProcess(IProcess iprocess) 
	{

	}

	/**
	 * Remove the console for this process
	 * 
	 * @param process
	 */
	public static void deleteLaunch(IProcess iprocess) {
		if (iprocess instanceof ProcessAdapter) {
			ProcessAdapter adapter = (ProcessAdapter) iprocess;
			ILaunch launch = adapter.getLaunch();
			if (launch != null) {
				DebugPlugin.getDefault().getLaunchManager()
						.removeLaunch(launch);
			}
		}
	}



	public static void registerLaunchProcess(final IProcess iprocess) {
		if (iprocess instanceof ProcessAdapter) {
			ProcessAdapter processAdapter = (ProcessAdapter) iprocess;
			ILaunch launch = processAdapter.getLaunch();
			if (launch != null) {
				launch.addProcess(processAdapter);
			}

			Display.getDefault().syncExec(new Runnable() {
				public void run() {
					IConsole console = getConsole(iprocess);
					showConsole(console);
				}
			});
		}
	}




	/**
	 * Returns the console for the given process, or <code>null</code> if
	 * none.
	 * 
	 * @param process
	 * @return the console for the given process, or <code>null</code> if none
	 */
	private static IConsole getConsole(IProcess process) {
		IConsoleManager manager = ConsolePlugin.getDefault()
				.getConsoleManager();
		IConsole[] consoles = manager.getConsoles();
		for (int i = 0; i < consoles.length; i++) {
			IConsole console = consoles[i];
			if (console instanceof org.eclipse.debug.ui.console.IConsole) {
				if (((org.eclipse.debug.ui.console.IConsole) console)
						.getProcess().equals(process)) {
					return console;
				}
			}
		}
		return null;
	}

	private static TRCProcessProxy getProcessFromInput(Object input) {
		TRCProcessProxy processInput = null;
		if (input instanceof TRCProcessProxy)
			processInput = (TRCProcessProxy) input;
		else if (input instanceof TRCAgentProxy)
			processInput = ((TRCAgentProxy) input).getProcessProxy();

		return processInput;
	}

	
	public void selectionChanged(IWorkbenchPart part, ISelection sel) {
		if (sel != null && !sel.isEmpty()) {
			IStructuredSelection selection = (IStructuredSelection) sel;
			IProcess process = ProcessMap.get(getProcessFromInput(selection
					.getFirstElement()));
			final IConsole console = getConsole(process);

			showConsole(console);
		}
	}

	/**
	 * @param console
	 */
	private static void showConsole(final IConsole console) {

		if (console == null)
			return;

		IWorkbenchWindow window = UIPlugin.getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPage page = window.getActivePage();
			if (page != null) {
				IViewPart consoleView = page
						.findView(IConsoleConstants.ID_CONSOLE_VIEW);
				if (consoleView != null) {
					// display (ie. update the content) the console, if it
					// exists
					// but do not bring it to the front
					if (consoleView instanceof IConsoleView) {
						((IConsoleView) consoleView).display(console);
					}
				}
			}
		}
	}


}
