/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileEventListener.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A profile event set listener registers with the profile plug-in
 * to receive profile event notification from the application being profiled.
 */
public interface ProfileEventListener {
	/**
	 * Notifies this listener of the given profile event.
	 *
	 * @param event the trace event
	 */
	public void handleProfileEvent(ProfileEvent event);
}
