/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AbstractListenerActionDelegate.java,v 1.5 2006/09/20 18:53:54 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AbstractListenerActionDelegate
	extends org.eclipse.tptp.platform.common.ui.trace.internal.actions.AbstractListenerActionDelegate
{
	/**
	 * Returns the page that this action works in.
	 */
	protected IWorkbenchPage getPage() {
		if (getWindow() != null) {
			return getWindow().getActivePage();
		} else {
			if (!Display.getDefault().isDisposed() &&
				UIPlugin.getDefault().getViewer() != null &&
				!UIPlugin.getDefault().getViewer().getControl().isDisposed() &&
				UIPlugin.getActiveWorkbenchWindow() != null) {
				return UIPlugin.getActiveWorkbenchWindow().getActivePage();
			}
			return null;
		}
	}
}
