/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CollectObjRefActionDelegate.java,v 1.12 2006/12/29 19:16:46 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;

/*
 * CONTEXT_ID sthp0000 for dump object reference action
 */

public class CollectObjRefActionDelegate extends AbstractListenerActionDelegate
{

	/**
	 * Executes this action Ali M.: As a result of
	 * https://bugs.eclipse.org/bugs/show_bug.cgi?id=151646: fViewer maybe null.
	 * It's value must be checked before used.
	 * 
	 * @param agent The agent selected
	 * @param fViewer The view acting as the context of this action 
	 */
	public void run(TRCAgentProxy fAgent, INavigator fViewer)
	{

		if (fAgent == null)
			return;

		if (!fAgent.isMonitored())
		{
			MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(),
					TraceMessages.TRC_MSGT, TraceMessages.COBJR_INFO_);
			return;
		}

		if (fAgent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE))
		{
			TRCProcessProxy process = fAgent.getProcessProxy();

			String hostName = process.getNode().getName();
			try
			{
				Node node = PDCoreUtil.profileConnect(hostName, String
						.valueOf(process.getNode().getPort()));
				if (node == null)
				{
					return;
				}

				Object instance = LoadersUtils.locateAgentInstance(fAgent);
				if (instance != null && instance instanceof Agent)
				{
					Agent a = (Agent) instance;
					CustomCommand command = new CustomCommand();

					command.setData("ANALYSEHEAP");
					a.invokeCustomCommand(command);
				}

			} catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}

	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	public boolean isEnabledFor(Object element)
	{

		if (element == null)
			return false;

		if (element instanceof TRCAgentProxy)
		{
			TRCAgentProxy agent = (TRCAgentProxy) element;
			return (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE)
					&& agent.isMonitored() && collectInstanceInformation(agent));
		}

		if (element instanceof TRCProcessProxy)
		{
			EList agents = ((TRCProcessProxy) element).getAgentProxies();

			for (int idx = 0; idx < agents.size(); idx++)
			{
				TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
				if (agent.eIsProxy())
					continue;

				if (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE)
						&& agent.isMonitored()
						&& collectInstanceInformation(agent))
					return true;
			}
		}

		return false;

	}

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception
	{

		if (object == null
				|| (!(object instanceof TRCAgentProxy) && !(object instanceof TRCProcessProxy)))
			return;


		INavigator fViewer = (INavigator) getView();
		TRCAgentProxy agent = null;
		if (object instanceof TRCAgentProxy)
		{
			agent = (TRCAgentProxy) object;
		} else if (object instanceof TRCProcessProxy)
		{
			EList agents = ((TRCProcessProxy) object).getAgentProxies();

			for (int idx = 0; idx < agents.size(); idx++)
			{
				TRCAgentProxy ag = (TRCAgentProxy) agents.get(idx);
				if (ag.eIsProxy())
					continue;

				if (ag.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE))
					agent = ag;
			}
		}

		run(agent, fViewer);
	}

	private boolean collectInstanceInformation(TRCAgentProxy agent)
	{
		TRCCollectionMode type = agent.getCollectionMode();
		if (type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL)
			return false;

		Iterator configs = agent.getConfigurations().iterator();
		if (configs.hasNext())
		{
			TRCConfiguration config = (TRCConfiguration) configs.next();
			EList options = config.getOptions();

			if (options != null)
			{
				Iterator i = options.iterator();
				while (i.hasNext())
				{
					TRCOption option = (TRCOption) i.next();

					if (option.getKey().equals(Options.OPTION_TRACE_MODE))
					{
						if (option.getValue().equals(
								Options.OPTION_VALUE_NOOBJECTCORRELATION))
							return false;
					}
				}
			}
		}

		return true;
	}

	public void dispose()
	{
		super.dispose();
	}
}
