/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetachActionDelegate.java,v 1.6 2006/07/26 14:18:45 amehregani Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;

public class DetachActionDelegate extends AbstractListenerActionDelegate
{

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception
	{
		if ((object == null) || !(object instanceof TRCAgentProxy))
		{
			return;
		}

		INavigator fViewer = (INavigator) getView();
		run((TRCAgentProxy) object, fViewer);
	}

	/**
	 * Executes this action Ali M.: As a result of
	 * https://bugs.eclipse.org/bugs/show_bug.cgi?id=151646: fViewer maybe null.
	 * It's value must be checked before used.
	 * 
	 * @param agent The agent selected
	 * @param fViewer The view acting as the context of this action 
	 */
	public void run(TRCAgentProxy agent, INavigator fViewer)
	{

		try
		{
			PDCoreUtil.detachAgent(agent);

			ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

			event.setSource(agent);
			event.setType(ProfileEvent.DETACH);

			UIPlugin.getDefault().notifyProfileEventListener(event);
		} catch (Exception exc)
		{
			exc.printStackTrace();
		}
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	public boolean isEnabledFor(Object element)
	{
		if ((element != null) && (element instanceof TRCAgentProxy)
				&& ((TRCAgentProxy) element).isAttached())
		{
			return true;
		}

		return false;
	}

	public void dispose()
	{
		super.dispose();
	}
}
