/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenProfilePerspectiveAction.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.ui.*;

/**
 * Action to programmatically open a Profiling perspective.
 * 
 * <p>
 * This class may be instantiated; it is not intended to be subclassed.
 * </p>
 * 
 * @since 2.0
 */
public class OpenProfilePerspectiveAction extends Action {

	/**
	 * Create a new <code>OpenProfilePerspectiveAction</code>.
	 */
	public OpenProfilePerspectiveAction() {
	}

	public void run() {
		IWorkbench workbench= UIPlugin.getDefault().getWorkbench();
		IWorkbenchWindow window= workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page= window.getActivePage();
		IAdaptable input;
		if (page != null)
			input= page.getInput();
		else
			input= ResourcesPlugin.getWorkspace().getRoot();
		try {
			workbench.showPerspective(PDPerspective.ID_TRACE_PERSPECTIVE, window, input);
		} catch (WorkbenchException e) {
			
			e.printStackTrace();
		}
	}
}
