/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RefreshFromLocalAction.java,v 1.16 2006/09/20 18:53:54 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;

/*
* CONTEXT_ID refl0000 for refresh from local action
*/

public class RefreshFromLocalAction extends org.eclipse.tptp.platform.common.ui.trace.internal.actions.RefreshFromLocalAction
{
  private INavigator fViewer;

  public RefreshFromLocalAction(INavigator viewer)
  {
	super(viewer);
  }
  
  public void run()
  {
	super.run();
	if(!(fViewer instanceof PDProjectExplorer))	
	{	
		ProfileEvent event = new ProfileEvent();
		event.setSource(ResourcesPlugin.getWorkspace().getRoot());		
		event.setType(ProfileEvent.REFRESH_LOG_NAVIGATOR);
		UIPlugin.getDefault().notifyProfileEventListener(event);		
	}
	else
		fViewer.getViewer().refresh();	
  } 
}
