/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RunGCActionDelegate.java,v 1.10 2006/12/29 19:16:46 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.actions.AbstractProfileActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;

/*
 * CONTEXT_ID rgca0000 for run garbage collection action
 */

public class RunGCActionDelegate extends AbstractListenerActionDelegate
{

	/**
	 * Executes this action Ali M.: As a result of
	 * https://bugs.eclipse.org/bugs/show_bug.cgi?id=151646: fViewer maybe null.
	 * It's value must be checked before used.
	 * 
	 * @param agent The agent selected
	 * @param fViewer The view acting as the context of this action 
	 */
	public void run(TRCAgentProxy fAgent, INavigator fViewer)
	{

		if (!fAgent.isMonitored())
		{
			MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(),
					UIPlugin.getResourceString(TraceMessages.TRC_MSGT),
					UIPlugin.getResourceString(TraceMessages.RUN_GC_INFO_));
			return;
		}

		if (fAgent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE))
		{
			TRCProcessProxy process = fAgent.getProcessProxy();

			String hostName = process.getNode().getName();
			try
			{
				Node node = PDCoreUtil.profileConnect(hostName, String
						.valueOf(process.getNode().getPort()));
				if (node == null)
				{

					return;
				}

				Object instance = LoadersUtils.locateAgentInstance(fAgent);
				if (instance != null && instance instanceof Agent)
				{
					Agent a = (Agent) instance;

					CustomCommand command = new CustomCommand();

					command.setData("RUNGC");
					a.invokeCustomCommand(command);

				}

			} catch (Exception exc)
			{
				exc.printStackTrace();
			}
		}
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	public boolean isEnabledFor(Object element)
	{

		if (element == null)
			return false;

		if (element instanceof TRCAgentProxy)
		{

			TRCAgentProxy agent = (TRCAgentProxy) element;

			return (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) && agent
					.isMonitored());
		}

		if (element instanceof TRCProcessProxy)
		{
			EList agents = ((TRCProcessProxy) element).getAgentProxies();

			for (int idx = 0; idx < agents.size(); idx++)
			{
				TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
				if (agent.eIsProxy())
					continue;

				if (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE)
						&& agent.isMonitored())
					return true;
			}
		}

		return false;
	}

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception
	{

		if (object == null || !(object instanceof TRCAgentProxy))
			return;

		INavigator fViewer = (INavigator) getView();
		run((TRCAgentProxy) object, fViewer);
	}

	public void dispose()
	{
		super.dispose();
	}

}
