/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StopTraceActionDelegate.java,v 1.5 2006/05/11 15:05:06 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.ProfileUIManager;

/**
 * The UI action to stop monitoring an agent. When an agent is not monitored,
 * the workbench will discard all data received from the agent.
 * 
 * CONTEXT_ID sttr0000 for stop monitor(trace) action
 */
public class StopTraceActionDelegate extends AbstractListenerActionDelegate {

    /**
     * Stops monitoring the given agent.
     * 
     * @param object the agent to stop monitoring. 
     * @see AbstractProfileActionDelegate#doAction(Object)
     */
	public void doAction(Object object) {
        if (object != null && object instanceof TRCAgentProxy) {
            ProfileUIManager.getInstance().stopMonitoring((TRCAgentProxy)object);
        }
	}
	
    /**
     * Returns whether or not this action should be enabled for the given
     * agent.
     * 
     * @param element the element to test with.
     * @return whether or not this action should be enabled.
     * @see AbstractProfileActionDelegate#isEnabledFor(Object)
     */
	public boolean isEnabledFor(Object element) {
		if (element != null
			&& (element instanceof TRCAgentProxy)
			&& ((TRCAgentProxy) element).isMonitored()) {
			
			if (getAction()!=null)
				getAction().setEnabled(true);
			return true;
		}
		if (getAction()!=null)
			getAction().setEnabled(false);						
		return false;
	}
	
    /**
     * Disposes of any resources used by this action.
     */
	public void dispose() {
		super.dispose();
	}
}
