/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceLogActionGroup.java,v 1.20 2010/05/12 20:25:47 kchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.hyades.log.ui.internal.OpenLogAgentWizard;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.navigator.ProfileDetailItem;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;


/**
 * @author apnan
 */
public class TraceLogActionGroup extends org.eclipse.tptp.platform.common.ui.trace.internal.actions.TraceLogActionGroup {

	//protected INavigator fViewer; 
	protected OpenWizardAction fOpenLogAgentAction;

	
	class ImportActionGroup extends ActionGroup
	{
		 private ImportResourcesAction fImportAction;
		 private ExportResourcesAction fExportAction;
		
		 /**
		  * Creates a new <code>ImportActionGroup</code>. The group 
		  * requires that the selection provided by the part's selection provider 
		  * is of type <code>org.eclipse.jface.viewers.IStructuredSelection</code>.
		  * 
		  * @param part the view part that owns this action group
		  */
		 public ImportActionGroup(INavigator part) {
			 IWorkbenchWindow workbench = part.getSite().getWorkbenchWindow();
			 fImportAction= new ImportResourcesAction(workbench);
			 fExportAction= new ExportResourcesAction(workbench);	
			PDPluginImages.setImageDescriptors(fImportAction, PDPluginImages.T_LCL, PDPluginImages.IMG_IMPORT);
			PDPluginImages.setImageDescriptors(fExportAction, PDPluginImages.T_LCL, PDPluginImages.IMG_EXPORT);
				 		
		 }
			
		 /* (non-Javadoc)
		  * Method declared in ActionGroup
		  */
		 public void fillContextMenu(IMenuManager menu) {
			 menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fImportAction);
			 menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, fExportAction);
				
			 super.fillContextMenu(menu);
		 }	
	 }

	/*
	 * Constructor for TraceLogActionGroup
	 * @param logNavigator
	 */
	public TraceLogActionGroup(INavigator viewer)
	{
		super(viewer);
		
		//fViewer = viewer;
		//createActions();
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup#createActions()
	 */
	protected void createActions() 
	{
		super.createActions();		
		fOpenLogAgentAction = new OpenWizardAction(getNavigator(), OpenLogAgentWizard.class, UIPlugin.getResourceString(TraceMessages.PROP));
	}
	
	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menu)
	{		
		super.fillContextMenu(menu);	
		openReportAction.selectionChanged((IStructuredSelection)getContext().getSelection());
		if(openReportAction.isApplicableForSelection())
		{
			menu.appendToGroup(INavigatorContribution.GROUP_IMPORT, openReportAction);
		}
	}
	
	public void fillContextMenuWithGroups(IMenuManager menu)
	{
		super.fillContextMenu(menu);
	}
	



	/**
	 * Returns the default action for the specified object
	 * (for when the user double clicks on it).
	 */
	protected IAction getDefaultAction(Object obj) {
		// this set stays sorted
		Set children = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				if (o1 instanceof INavigatorItem && o2 instanceof INavigatorItem) {
					return ((INavigatorItem)o1).getText().compareTo(((INavigatorItem)o2).getText());
				}
				return o1.hashCode() - o2.hashCode();
			}
		});

		if(obj instanceof TRCMonitor) {
			IAction action = getDefaultViewMappingForType(CommonUITraceConstants.MONITOR_TYPE);
			if (action != null) {
				return action;
			}
			children.addAll(((TRCMonitor)obj).getNodes());
		}
		else if(obj instanceof TRCNode) {
			IAction action = getDefaultViewMappingForType(CommonUITraceConstants.HOST_TYPE);
			if (action != null) {
				return action;
			}
			children.addAll(((TRCNode)obj).getProcessProxies());
		}
		else if(obj instanceof TRCProcessProxy)	{
			children.addAll(((TRCProcessProxy)obj).getAgentProxies());
		}
		else if(obj instanceof CorrelationContainerProxy)	{
			children.addAll(((CorrelationContainerProxy)obj).getCorrelatedAgents());
		}
		else if(obj instanceof TRCAgentProxy) {
			children.addAll(NavigatorExtensionUtil.getAllChildren(obj, PDProjectExplorer.ID));
			if (((TRCAgentProxy)obj).getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE) && !hasProfilingTypes(obj)) {
				
				//bug303252 
				//Get default view action for agent with no analysis type.
				IAction action = getDefaultViewMappingForType(((TRCAgentProxy)obj).getType());
				if (action != null) {
					return action;
				}
				
				Map typesMap = ProfilingSetsManager.instance().getProfilingTypes();
				Iterator iter = typesMap.values().iterator();
				while (iter.hasNext()) {
					IProfilingSetType next = (IProfilingSetType)iter.next();
					children.add(new ProfileDetailItem(obj, next.getName(), next.getId(), null));
				}
			}
			
			/*
			 * Find out whether there exists a viewer for any
			 * of the profiling types.
			 */
			boolean hasViewer = false;
			Iterator iter = children.iterator();
			while (iter.hasNext()) {
				if (getDefaultAction(iter.next()) != null) {
					hasViewer = true;
					break;
				}
			}
			
			/*
			 * If not, fall back to the agent's default viewer.
			 */
			if (!hasViewer) {
				IAction action = getDefaultViewMappingForType(((TRCAgentProxy)obj).getType());
				if (action != null) {
					return action;
				}
			}
		}
		else if(obj instanceof INavigatorItem) {
			IAction action = getDefaultViewMappingForType(((INavigatorItem)obj).getType());
			if (action != null) {
				return action;
			}
		}
		
		children.addAll(NavigatorExtensionUtil.getAllChildren(obj, PDProjectExplorer.ID));
		Iterator iter = children.iterator();
		while (iter.hasNext()) {
			IAction action = getDefaultAction(iter.next());
			if (action != null) {
				return action;
			}
		}
		return null;
	}

	/**
	 * Returns true if the given object has one or more profiling
	 * types directly below it.
	 */
	protected boolean hasProfilingTypes(Object obj) {
		Iterator iter = NavigatorExtensionUtil.getAllChildren(obj, PDProjectExplorer.ID).iterator();
		while (iter.hasNext()) {
			if (iter.next() instanceof ProfileDetailItem) {
				return true;
			}
		}
		return false;
	}
}
