/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceFileUI.java,v 1.13 2006/02/07 20:30:29 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;

import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ibm.icu.text.MessageFormat;

public class TraceFileUI extends AbstractChangeable implements SelectionListener
{
	private Button _sentToFileCheckBox;
	private Label  _fileLabel;
	private Text   _file;
	private Button _browseLocation;
	private Label  _note;


public TraceFileUI() {
	super();
}

public Composite createControl(Composite parent)
{
	
	GridLayout layout;
	GridData   data;
		
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 3;
	layout.verticalSpacing=2;
	layout.marginHeight = 25;
	layout.verticalSpacing = 6;
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	result.setLayoutData(data);
	
	_sentToFileCheckBox = new Button(result, SWT.CHECK);
	_sentToFileCheckBox.setText(UIPlugin.getResourceString(TraceMessages.SEND_TOF));
	_sentToFileCheckBox.setToolTipText(UIPlugin.getResourceString(TraceMessages.SEND_TOFT));
	data = new GridData();
	data.horizontalSpan = 3;
	_sentToFileCheckBox.setLayoutData(data);

	_fileLabel = new Label(result, SWT.NULL);
	_fileLabel.setText(UIPlugin.getResourceString(TraceMessages.PROF_FL));

	_file = new Text(result, SWT.BORDER);
	_file.setLayoutData(GridUtil.createHorizontalFill());

	_browseLocation = new Button(result, SWT.NULL);
	_browseLocation.setText(UIPlugin.getResourceString(TraceMessages.BROWSE2));

	_note = new Label(result, SWT.NULL);
	_note.setText(UIPlugin.getResourceString(TraceMessages.PROF_FLN));
	data = new GridData();
	data.horizontalSpan = 3;
	_note.setLayoutData(data);
	
	_sentToFileCheckBox.addSelectionListener(this);
	_browseLocation.addSelectionListener(this);
	_file.addKeyListener(new KeyListener() {
		public void keyPressed(KeyEvent e) {
			changed();
		}
		
		public void keyReleased(KeyEvent e) {
			changed();
		}
	});
	
	initData();
	
	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_sentToFileCheckBox,
		UIPlugin.getPluginId()+".sttf0000");

	PlatformUI.getWorkbench().getHelpSystem().setHelp(
		_file,
		UIPlugin.getPluginId()+".sttf0001");
	
	return result;
}

public String getFile() 
{
	return _file.getText();
}
public void setFile(String file)
{
	_file.setText(file);
}
public Button getExternalBox()
{
	return _sentToFileCheckBox;
}
public Text getFileText()
{
	return _file;
}
public boolean getSelection()
{
	return _sentToFileCheckBox.getSelection();
}

private void initData()
{
	_sentToFileCheckBox.setSelection(false);
	setEnabled(false);
	_file.setText("");
}

public void setEnabled(boolean enable)
{
	_fileLabel.setEnabled(enable);
	_file.setEnabled(enable);
	_file.setEditable(enable);
	_browseLocation.setEnabled(enable);
	_note.setEnabled(enable);
}

public void setVisible(boolean enable)
{
	_sentToFileCheckBox.setVisible(enable);
	_fileLabel.setVisible(enable);
	_file.setVisible(enable);
	_browseLocation.setVisible(enable);
	_note.setVisible(enable);
}

private void showResourceDialog()
{
	Shell shell = UIPlugin.getActiveWorkbenchWindow().getShell();
	String osName = System.getProperty("os.name");
	String oldFile = _file.getText();
	String newFile = "";

	FileDialog dlg = new FileDialog(shell);
	dlg.setFilterExtensions(new String[] {"*.trcxml","*"});
	dlg.open();

	String fileName = dlg.getFileName();
	//System.out.println(fileName);
	if(fileName != null && !fileName.equals(""))
	{

      if (fileName.indexOf(".")<0) fileName += ".trcxml";
	  String classpath = dlg.getFilterPath();
	  if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":")))
	  {
	 	classpath += "\\";
	  }

	  newFile = classpath+File.separator+fileName;
	  _file.setText(newFile);
	  
//	  try {
		  File tempFile = new File(newFile.trim());
		  if (tempFile.exists()) {//&& !PDCoreUtil.isZipFile(newFile.trim())) { 
			String result = queryOverwrite(newFile.trim());
			if (result.equals("NO") || result.equals("CANCEL") ) {
				if (newFile.equalsIgnoreCase(oldFile))
					_file.setText("");
				else
					_file.setText(oldFile);
			}
		  }
//	  }
//	  catch (IOException e) {
//	  	UIPlugin.getDefault().log(e);
//	  }
	}       
}

/**
 * @param pathString 
 * @return the user's reply: one of <code>"YES"</code>, <code>"NO"</code>, or <code>"CANCEL"</code>
 */
public String queryOverwrite(String pathString) {

	Path path = new Path(pathString);

	String messageString;
	//Break the message up if there is a file name and a directory
	//and there are at least 2 segments.
	if (path.getFileExtension() == null || path.segmentCount() < 2)
		messageString =
			MessageFormat.format(
					UIPlugin.getResourceString(TraceMessages.PRFF_APP), 
				new String[] { pathString });

	else
		messageString =
			MessageFormat.format(
					UIPlugin.getResourceString(TraceMessages.PRFF_APPN), 
				new String[] {
					path.lastSegment(),
					path.removeLastSegments(1).toOSString()});

		final MessageDialog dialog = new MessageDialog(_browseLocation.getShell(), UIPlugin.getResourceString(TraceMessages.TRC_MSGT), 
null,
	messageString,
	MessageDialog.QUESTION,
	new String[] {
		IDialogConstants.YES_LABEL,
		IDialogConstants.NO_LABEL,
		IDialogConstants.CANCEL_LABEL },
	0);
	String[] response = new String[] { "YES","NO","CANCEL" };//$NON-NLS-1$
	//run in syncExec because callback is from an operation,
	//which is probably not running in the UI thread.
	_browseLocation.getShell().getDisplay().syncExec(new Runnable() {
		
		public void run() {
			dialog.open();
		}
	});
	return dialog.getReturnCode() < 0
		? "CANCEL"
		: response[dialog.getReturnCode()];
}

public void widgetDefaultSelected(SelectionEvent e)
{}

public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _sentToFileCheckBox)
		setEnabled(_sentToFileCheckBox.getSelection());
	else if(e.widget == _browseLocation)
		showResourceDialog();
	
	changed();
}

}
