/**********************************************************************
 * Copyright (c) 2005,2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceLogUI.java,v 1.11 2006/05/02 14:09:16 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class TraceLogUI implements SelectionListener {

	private Table _list;
	private Button _delete;
	private Button _addAgent;
	private Button _editAgent;  //button for editing agent name
	private Text _newAgent;

	class AgentDialog extends Dialog implements ModifyListener {
		private Text agent;
		private String agentStr;
		private boolean isAdding;  //if the dialog is opened for adding a new agent name
		private String agentName;  //the agent name for modification
		
		public AgentDialog(boolean isAdding, String agentName) {
			super(Display.getCurrent().getActiveShell());
			this.isAdding = isAdding;
			this.agentName = agentName;
		}

		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			if (isAdding) {
				shell.setText(UIPlugin.getResourceString(TraceMessages.ADDLA));
			} else {
				shell.setText(UIPlugin.getResourceString(TraceMessages.EDITLA));
			}
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NONE);
			label.setText(UIPlugin.getResourceString(TraceMessages.LA_LBL));
			agent = new Text(result, SWT.BORDER);
			agent.setLayoutData(GridUtil.createHorizontalFill());
			agent.addModifyListener(this);
			
			agent.setText(isAdding ? "logAgent" : agentName);
			agent.setFocus();
			agent.selectAll();
			
			return result;
		}

		public void modifyText(ModifyEvent e) {
				if (getButton(IDialogConstants.OK_ID) != null)
					getButton(IDialogConstants.OK_ID).setEnabled(
							agent.getText().trim().length() > 0);
		}

		protected void okPressed() {
			agentStr = agent.getText().trim();
			super.okPressed();
		}
		
		/*
		 * Set the initial Ok button enablement.
		 */
		protected Control createContents(Composite parent) {
			Control result = super.createContents(parent);
			getButton(IDialogConstants.OK_ID).setEnabled(agent.getText().trim().length() > 0);
			return result;
		}

		/**
		 * @return Returns the agentStr.
		 */
		public String getAgentName() {
			return agentStr;
		}
	}
	
	public TraceLogUI() {
		super();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/06/2000 3:38:47 PM)
	 */
	protected void addAgent() {
		
		AgentDialog dialog = new AgentDialog(true, null);
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {
		
			addAgent(dialog.getAgentName());
			
			enableButtons();
			setAgentText();
		}
	}
	
	protected void editAgent() {
		int exist = -1;
		
		AgentDialog dialog = new AgentDialog(false, _newAgent.getText());
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {
			StringBuffer buffer = new StringBuffer(dialog.getAgentName());
			for (int idx = 0; idx < _list.getItemCount(); idx++) {
				if (buffer.toString().equals(_list.getItem(idx).getText()))
				{	
					exist = idx;
				}
			}
			if (exist>0)
			{
				removeAgent();
				_list.select(exist>=_list.getItemCount()?exist-1:exist);
			}
			else
			{
				editAgent(buffer.toString());
			}
			
			enableButtons();
			setAgentText();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (4/30/2001 12:21:38 PM)
	 * @param name java.lang.String
	 */
	public void addAgent(String text) {
		
		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			if (text.equals(_list.getItem(idx).getText()))
			{	
				_list.select(idx);
				setAgentText();				
				return;
			}
		}

		TableItem item = new TableItem(_list, SWT.NONE);
		item.setText(text);

		_list.setSelection(new TableItem[] { item });
		setAgentText();
	}
	
	public void editAgent(String text) {
		int i = _list.getSelectionIndex();
		TableItem item = _list.getItem(i);
		item.setText(text.trim());
	}
	
	public Composite createControl(Composite parent) {
		GridLayout layout;
		GridData gd;

		Composite _result = new Composite(parent, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 2;
		_result.setLayout(layout);
		_result.setLayoutData(GridUtil.createFill());

		_list = new Table(_result, SWT.BORDER | SWT.H_SCROLL);
		gd = GridUtil.createFill();
		_list.setLayoutData(gd);

		Composite buttons = new Composite(_result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 3;
		buttons.setLayout(layout);
		gd = new GridData();
//		gd.verticalAlignment = GridData.FILL;
//		gd.grabExcessVerticalSpace = true;
//		gd.widthHint = 120;
		buttons.setLayoutData(gd);

		_editAgent = new Button(buttons, SWT.NULL);
		_editAgent.setLayoutData(GridUtil.createHorizontalFill());
		_editAgent.setText(UIPlugin.getResourceString(TraceMessages.PEDT));
		
		_addAgent = new Button(buttons, SWT.PUSH);
		_addAgent.setText(UIPlugin.getResourceString(TraceMessages.PADD));
		_addAgent.setLayoutData(GridUtil.createHorizontalFill());
		
		_delete = new Button(buttons, SWT.PUSH | SWT.NULL);
		_delete.setText(UIPlugin.getResourceString(TraceMessages.RMV_TXT));
		_delete.setLayoutData(GridUtil.createHorizontalFill());
		Composite space = new Composite(buttons, SWT.NULL);
		space.setLayout(layout);
		space.setLayoutData(GridUtil.createFill());

		Composite addAgent = new Composite(_result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 3;
		addAgent.setLayout(layout);
		addAgent.setLayoutData(GridUtil.createHorizontalFill());

		Label label = new Label(addAgent, SWT.NULL);
		label.setText(UIPlugin.getResourceString(TraceMessages.LA_LBL));
		_newAgent = new Text(addAgent, SWT.BORDER);
		_newAgent.setLayoutData(GridUtil.createHorizontalFill());
		_newAgent.setEditable(false);
		
		_editAgent.addSelectionListener(this);
		_delete.addSelectionListener(this);
		_addAgent.addSelectionListener(this);
		//_newAgent.addModifyListener(this);  //user cannot modify agent name this way any more

		_list.addSelectionListener(this);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				_list,
				UIPlugin.getPluginId()+".lapp0001");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				_editAgent,
				UIPlugin.getPluginId()+".lapp0002");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				_delete,
				UIPlugin.getPluginId()+".lapp0003");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				_addAgent,
				UIPlugin.getPluginId()+".lapp0004");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
				_newAgent,
				UIPlugin.getPluginId()+".lapp0005");
		
		return _result;
	}
	
	public String[] getAgents() {
		
		TableItem[] items = _list.getItems();
		String[] agents = new String[items.length];
		
		for(int idx=0; idx<items.length; idx++)
		{
			agents[idx]=items[idx].getText();
		}
		
		return agents;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:51:52 PM)
	 * @param event org.eclipse.swt.events.ModifyEvent
	 */
	/*public void modifyText(ModifyEvent event) {  //user cannot modify agent name this way any more
		if (event.widget == _newAgent)
		{
			TableItem[] selected = _list.getSelection();			
			if(selected.length > 0)
			{
				selected[0].setText(_newAgent.getText().trim());
			}
		}
	}*/
	/**
	 * Insert the method's description here.
	 * Creation date: (11/06/2000 3:52:27 PM)
	 */
	protected void removeAgent() {
		int i = _list.getSelectionIndex();
		if (i != -1)
			_list.remove(i);
		
		_newAgent.setText("");
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (4/30/2001 12:22:33 PM)
	 */
	public void reset() {
		_list.removeAll();
		_delete.setEnabled(false);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:49:33 PM)
	 * @param event org.eclipse.swt.events.SelectionEvent
	 */
	public void widgetDefaultSelected(SelectionEvent event) {
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/21/2000 7:49:33 PM)
	 * @param event org.eclipse.swt.events.SelectionEvent
	 */
	public void widgetSelected(SelectionEvent event) {
		if (event.widget == _editAgent)
			editAgent();
		else if (event.widget == _addAgent)
			addAgent();
		else if (event.widget == _delete) {
			int i = _list.getSelectionIndex();
			
			removeAgent();
			
			_list.setSelection(i<_list.getItemCount() ? i : (_list.getItemCount()>0 ? _list.getItemCount()-1 : -1));
			
			enableButtons();
			setAgentText();
		} else if (event.widget == _list) {
			enableButtons();
			setAgentText();
		}		
	}
	
	public void enableButtons() {
		int idx = _list.getSelectionIndex();
		if(idx == -1)
		{
			_editAgent.setEnabled(false);
			_delete.setEnabled(false);
			return;
		}
		
		_editAgent.setEnabled(true);
		_delete.setEnabled(true);
	}
	
	private void setAgentText()
	{
		TableItem[] selected = _list.getSelection();				
		if(selected.length > 0)
		{
			_newAgent.setText(selected[0].getText());
		}
		else
		{
			_newAgent.setText("");
		}
		
	}
	
}