/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceOptionsUI.java,v 1.17 2008/03/11 18:47:26 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

/*
* CONTEXT_ID tbpp0001 for Enable Profiling checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0002 for Enable JVM RAS information checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0003 for Enable Logging checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0004 for Default Trace Project Name entry field in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0005 for Enable Profiling Tips checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0006 for Local IBM Remote Agent port number entry field in Profiling(Trace) preference page
*/

public class TraceOptionsUI implements SelectionListener 
{
	private Button _enableInfoMsg;
	private Button _enableReloadMsg;
	private Button _always;
	private Button _never;
	private Button _prompt;
	private Button _alwaysPersp;
	private Button _neverPersp;
	private Button _promptPersp;
	private Text _projectName;
    private PreferencePage _preferencePage;
    
    private Button _manualRefreshBtn;
    private Button _automaticRefreshBtn;
    private Text   _refreshIntervalText;
    private Label   _refreshLabel;
    
/**
 * TraceOptionsUI constructor comment.
 */
public TraceOptionsUI(PreferencePage preferencePage) {
	super();
	_preferencePage = preferencePage;
	
}

public TraceOptionsUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData data;
	
	Composite content = new Composite(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing = 10;
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createFill()); 

	Group profilingInfo = new Group(content, SWT.NULL);
	profilingInfo.setText(UIPlugin.getResourceString(TraceMessages.PROF_INF_GRP));	
	layout = new GridLayout();
	layout.numColumns = 2;
	profilingInfo.setLayout(layout);
	profilingInfo.setLayoutData(GridUtil.createHorizontalFill());
		
	Label desc = new Label(profilingInfo, SWT.NULL);
	desc.setText(UIPlugin.getResourceString(TraceMessages.TRCOPT));
	_projectName = new Text(profilingInfo, SWT.BORDER);
	data = GridUtil.createHorizontalFill();
	_projectName.setLayoutData(data);

	_enableInfoMsg = new Button(profilingInfo, SWT.CHECK);
	_enableInfoMsg.setText(UIPlugin.getResourceString(TraceMessages.SP_TIP));
	data = new GridData();
	data.horizontalSpan = 2;
	_enableInfoMsg.setLayoutData(data);

	_enableReloadMsg = new Button(profilingInfo, SWT.CHECK);
	_enableReloadMsg.setText(UIPlugin.getResourceString(TraceMessages.SREL));
	data = new GridData();
	data.horizontalSpan = 2;
	_enableReloadMsg.setLayoutData(data);

	Group saveOnExitGroup = new Group(content, SWT.NONE);
	saveOnExitGroup.setText(UIPlugin.getResourceString(TraceMessages.SAVE_EXITG));
	layout = new GridLayout();
	layout.numColumns = 3;
	saveOnExitGroup.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	saveOnExitGroup.setLayoutData(data);
	
	_always = new Button(saveOnExitGroup, SWT.RADIO);
	_always.setText(UIPlugin.getResourceString(TraceMessages.ALWAYS));

	_never = new Button(saveOnExitGroup, SWT.RADIO);
	_never.setText(UIPlugin.getResourceString(TraceMessages.NEVER));

	_prompt = new Button(saveOnExitGroup, SWT.RADIO);
	_prompt.setText(UIPlugin.getResourceString(TraceMessages.PROMPT));

	Group switchPerspGroup = new Group(content, SWT.NONE);
	switchPerspGroup.setText(UIPlugin.getResourceString(TraceMessages.SPERS_G));
	layout = new GridLayout();
	layout.numColumns = 3;
	switchPerspGroup.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	switchPerspGroup.setLayoutData(data);
	
	_alwaysPersp = new Button(switchPerspGroup, SWT.RADIO);
	_alwaysPersp.setText(UIPlugin.getResourceString(TraceMessages.ALWAYS));

	_neverPersp = new Button(switchPerspGroup, SWT.RADIO);
	_neverPersp.setText(UIPlugin.getResourceString(TraceMessages.NEVER));

	_promptPersp = new Button(switchPerspGroup, SWT.RADIO);
	_promptPersp.setText(UIPlugin.getResourceString(TraceMessages.PROMPT));

	Group refreshGroup = new Group(content, SWT.NONE);
	refreshGroup.setText(UIPlugin.getResourceString(TraceMessages.REF_VGRP));
	layout = new GridLayout();
	layout.numColumns = 2;
	refreshGroup.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	refreshGroup.setLayoutData(data);
	
	_manualRefreshBtn = new Button(refreshGroup, SWT.RADIO);
	_manualRefreshBtn.setText(UIPlugin.getResourceString(TraceMessages.MN_REF));
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	_manualRefreshBtn.setLayoutData(data);
	
	_automaticRefreshBtn = new Button(refreshGroup, SWT.RADIO);
	_automaticRefreshBtn.setText(UIPlugin.getResourceString(TraceMessages.AUT_REF));
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;	
	_automaticRefreshBtn.setLayoutData(data);
	
	_refreshLabel = new Label(refreshGroup, SWT.NULL);
	data = new GridData();
	data.horizontalIndent = 20;
	_refreshLabel.setLayoutData(data);	
	_refreshLabel.setText(UIPlugin.getResourceString(TraceMessages.RF_INT));
	_refreshIntervalText = new Text(refreshGroup, SWT.BORDER);
	_refreshIntervalText.setLayoutData(GridUtil.createHorizontalFill());
	
	_manualRefreshBtn.addSelectionListener(this);
	_automaticRefreshBtn.addSelectionListener(this);
		
	initializeValues();
	
	Dialog.applyDialogFont( content );
		
	return content; 
}

/**
 * 
 * @return profiling message
 */
public boolean getInfoMsgOption(){
	return _enableInfoMsg.getSelection();
}

/**
 * Returns the state of the "Show 'Free up memory...' warning" checkbox,
 * (true = checked).
 * 
 * @return the state of the "Show 'Free up memory...' warning" checkbox.
 */
public boolean getReloadMsgOption(){
	return _enableReloadMsg.getSelection();
}

/**
 * 
 * @return 1 if the refresh is automatic, 0 otherwise 
 */
public int getRefreshType(){
	return _automaticRefreshBtn.getSelection()?1:0;
}

public int getRefreshInterval(){
	
	try {
		return Integer.parseInt(_refreshIntervalText.getText().trim());
	}
	catch(NumberFormatException exc){
		
		return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.REFRESH_INTERVAL);
	}
}


/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:55 PM)
 * @return java.lang.String
 */
public String getProjectName() {
	return _projectName.getText().trim();
}

public String getSaveOnExitOption() {
	if (_always.getSelection()) {
		return MessageDialogWithToggle.ALWAYS;
	}
	else if (_never.getSelection()) {
		return MessageDialogWithToggle.NEVER;
	}
	else {
		return MessageDialogWithToggle.PROMPT;
	}
}

public String getSwitchPerspOption() {
	if (_alwaysPersp.getSelection()) {
		return MessageDialogWithToggle.ALWAYS;
	}
	else if (_neverPersp.getSelection()) {
		return MessageDialogWithToggle.NEVER;
	}
	else {
		return MessageDialogWithToggle.PROMPT;
	}
}

/**
 * Initializes states of the controls from the preference store.
 */
private void initializeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	setProjectName(store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));		
	setInfoMsgOption(store.getBoolean(TraceConstants.PROFILE_TIPS));
	setReloadMsgOption(store.getBoolean(CommonUITraceConstants.RELOAD_INFO));
	/* Navid Mehregani - bugzilla_158635: The SAVE_ON_EXIT_KEY option should be read and stored in the preference store of CommonUITracePlugin */ 
	setSaveOnExitOption(CommonUITracePlugin.getDefault().getPreferenceStore().getString(CommonUITraceConstants.SAVE_ON_EXIT_KEY));
	setSwitchPerspOption(CommonUIPlugin.getDefault().getPreferenceStore().getString(HyadesUI.SWITCH_TO_PERSPECTIVE_KEY));
	//necessary because there are two different Preference Stores writing to this UI
	// defect_155739.  N.M: There is actually 3 different preference stores.  UIPlugin, CommonUIPlugin, and CommonUITracePlugin
	setRefreshType(store.getInt(TraceConstants.REFRESH_TYPE), store.getInt(TraceConstants.REFRESH_INTERVAL));			
}

public void setRefreshType(int type, int interval)
{
	if(type == 1) //automatic
	{
		_manualRefreshBtn.setSelection(false);
		_automaticRefreshBtn.setSelection(true);		
	}
	else
	{
		_manualRefreshBtn.setSelection(true);
		_automaticRefreshBtn.setSelection(false);
		
		_refreshLabel.setEnabled(false);
		_refreshIntervalText.setEnabled(false);				
	}
	
	_refreshIntervalText.setText(String.valueOf(interval));	
}


public void setInfoMsgOption(boolean option){
	_enableInfoMsg.setSelection(option);
}

/**
 * Sets the state of the "Show 'Free up memory...' warning" checkbox. This
 * warning prompts the user for a confirmation before unloading the trace data
 * from memory. 
 * 
 * @param option the new checkbox state (true = checked).
 */
public void setReloadMsgOption(boolean option){
	_enableReloadMsg.setSelection(option);
}


/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:10 PM)
 * @param name java.lang.String
 */
public void setProjectName(String name)
{
	_projectName.setText(name);
}

public void setSaveOnExitOption(String value) {
	if (MessageDialogWithToggle.ALWAYS.equals(value)) {
		_always.setSelection(true);
		_never.setSelection(false);
		_prompt.setSelection(false);
	}
	else if (MessageDialogWithToggle.NEVER.equals(value)) {
		_never.setSelection(true);
		_always.setSelection(false);
		_prompt.setSelection(false);
	}
	else {
		_prompt.setSelection(true);
		_always.setSelection(false);
		_never.setSelection(false);
	}
}

public void setSwitchPerspOption(String value) {
	if (MessageDialogWithToggle.ALWAYS.equals(value)) {
		_alwaysPersp.setSelection(true);
		_neverPersp.setSelection(false);
		_promptPersp.setSelection(false);
	}
	else if (MessageDialogWithToggle.NEVER.equals(value)) {
		_neverPersp.setSelection(true);
		_alwaysPersp.setSelection(false);
		_promptPersp.setSelection(false);
	}
	else {
		_promptPersp.setSelection(true);
		_alwaysPersp.setSelection(false);
		_neverPersp.setSelection(false);
	}
}
/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _manualRefreshBtn || e.widget == _automaticRefreshBtn)
   {
		_refreshLabel.setEnabled(_automaticRefreshBtn.getSelection());
		_refreshIntervalText.setEnabled(_automaticRefreshBtn.getSelection());				  	 
   }
}

}
