/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceProcessUI.java,v 1.7 2005/08/09 02:48:50 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID opwp0003 for process id text field in open process wizard page
 */
/*
 * CONTEXT_ID opwp0004 for host text field in open process wizard page
 */

public class TraceProcessUI {
	protected TraceLocationUI _locationUI;

	protected LaunchProcessUI _processUI;

	protected Text _processId;

	protected Text _hostname;

	/**
	 * TraceOptionsUI constructor comment.
	 */
	public TraceProcessUI() {
		super();
	}

	/**
	 * Insert the method's description here. Creation date: (4/26/2001 3:45:54
	 * PM)
	 * 
	 * @param parent
	 *            org.eclipse.swt.widgets.Composite
	 */
	public Composite createControl(Composite parent) {
		Label label;
		GridData data;

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		content.setLayout(layout);
		GridData gd = GridUtil.createFill();
		content.setLayoutData(gd);

		_locationUI = new TraceLocationUI();
		_locationUI.createControl(content);
		_locationUI.setEnabled(false);

		new Label(content, SWT.NONE);

		_processUI = new LaunchProcessUI();
		_processUI.createControl(content);
		_processUI.enable(false);

		Composite group = new Composite(content, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 5;
		group.setLayout(layout);
		group.setLayoutData(GridUtil.createFill());

		label = new Label(group, SWT.SEPARATOR | SWT.HORIZONTAL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		label.setLayoutData(data);

		label = new Label(group, SWT.NONE);
		label.setText(UIPlugin
				.getResourceString(TraceMessages.OPWIZID));
		_processId = new Text(group, SWT.SINGLE | SWT.BORDER);
		_processId.setLayoutData(GridUtil.createHorizontalFill());

		label = new Label(group, SWT.NONE);
		label.setText(UIPlugin.getResourceString(TraceMessages.OPWIZH));
		_hostname = new Text(group, SWT.SINGLE | SWT.BORDER);
		_hostname.setLayoutData(GridUtil.createHorizontalFill());

		PlatformUI.getWorkbench().getHelpSystem().setHelp(_processId,
				UIPlugin.getPluginId() + ".opwp0003");
		PlatformUI.getWorkbench().getHelpSystem().setHelp(_hostname,
				UIPlugin.getPluginId() + ".opwp0004");

		return content;
	}

	public LaunchProcessUI getLaunchProcessUI() {
		return _processUI;
	}

	public TraceLocationUI getLocationUI() {
		return _locationUI;
	}

	/**
	 * Insert the method's description here. Creation date: (8/14/2001 1:14:45
	 * PM)
	 * 
	 * @return org.eclipse.swt.widgets.Text
	 */
	public Text getNodeNameUI() {
		return _hostname;
	}

	/**
	 * Insert the method's description here. Creation date: (8/14/2001 1:14:45
	 * PM)
	 * 
	 * @return org.eclipse.swt.widgets.Text
	 */
	public Text getProcessIdUI() {
		return _processId;
	}
}
