/**********************************************************************
 * Copyright (c) 2006, 2010 Intel Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceProfileFiltersExtendedUI.java,v 1.3 2010/08/22 22:10:13 jwest Exp $
 * 
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TraceProfileFiltersExtendedUI extends TraceProfileFiltersUI {

	private Button _autoFilterBtn;
	
	public TraceProfileFiltersExtendedUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		_control = createParentControl(parent);

		_autoFilterBtn = new Button(_control, SWT.CHECK);
		_autoFilterBtn.addSelectionListener(this);
		_autoFilterBtn.setText(UIPlugin.getResourceString(TraceMessages.FLT_AUTO));
		
		GridData data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_autoFilterBtn.setLayoutData(data);
		
		createVerticalIndent(_control);
		
		createFilterSet(_control);
		createFilterContents(_control);

		createNoteLabel(_control);

		return _control;
	}

	protected void enableButtons() {
		if (isAgentTerminated()) {
			_autoFilterBtn.setEnabled(false);
			enable(false);
			return;
		}
		super.enableButtons();
	}
	
	public void widgetSelected(final SelectionEvent event) {
		if (event.widget == _autoFilterBtn) {
			setAutoFilterCriteria(_autoFilterBtn.getSelection());
		} else {
			super.widgetSelected(event);
		}
	}

	/**
	 * Sets the agentTerminated and disables all ui controls when
	 * <code>false</code> value is set
	 * 
	 * @param agentTerminated The agentTerminated to set
	 */
	public void setAgentTerminated(boolean agentTerminated) {
		super.setAgentTerminated(agentTerminated);
		if (agentTerminated) {
			_autoFilterBtn.setEnabled(false);
		}
	}

	/*
	 * returns the active filter set
	 * used by ProfileFiltersTab
	 */
	public String getActiveFilterSet()
	{
		if (getAutoFilterCriteria()) {
			return TraceConstants.AUTO_GENERATED_FILTER_SET;
		}
		return super.getActiveFilterSet();
	}
	
	
	public FilterSetElement getActiveFilterSetElement() {
		return !getAutoFilterCriteria() ? super.getActiveFilterSetElement() : null;
	}
	
	public void setAutoFilterCriteria(final boolean isAuto) {
		_autoFilterBtn.setSelection(isAuto);
		boolean manualFilterCriteria = !_autoFilterBtn.getSelection();
		enable(manualFilterCriteria);
		if (manualFilterCriteria) {
			enableButtons();
		}
	}

	public boolean getAutoFilterCriteria() {
		return _autoFilterBtn.getSelection();
	}

	/** Whether or not to display the message saying that the 
	 * filter will be auto-populated. (Bug 323330) */
	protected void showAutoGenFilterMessage(boolean enabled) {
		// Call the parent to handle most of the work
		super.showAutoGenFilterMessage(enabled);
		
		// And then enable or disable just for the elements of this subclass.
		if(enabled) {
			_autoFilterBtn.setEnabled(false);
		} else {
			_autoFilterBtn.setEnabled(true);
		}
	}
}
