/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceProfileTypeGroupUI.java,v 1.3 2005/06/27 15:53:10 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;


public class TraceProfileTypeGroupUI
{
	
	private Label _name;
	private Label _description;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceProfileTypeGroupUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createControl(Composite parent, String name, String description)
{
	GridLayout layout;
	GridData   data;
	
	Composite result = new Composite(parent, SWT.NULL);
	layout = new GridLayout();
	result.setLayout(layout);
	data = GridUtil.createHorizontalFill();
	data.heightHint = 300;
	data.widthHint = 400;
	result.setLayoutData(data);

	_name = new Label(result, SWT.NULL);
	_name.setText(name);
	Font font = _name.getFont();
	if (font != null) {
		FontData[] fonts = font.getFontData();
		if (fonts != null && fonts.length >= 1) {
			_name.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
		}
	}

	_description = new Label(result, SWT.WRAP);
	_description.setText(description);
	data = new GridData();
	data.horizontalIndent = 20;
	data.widthHint = 375;
	_description.setLayoutData(data);
	
	return result;
}


	/**
	 * @return Returns the _description.
	 */
	public String getDescription() {
		return _description.getText();
	}
	/**
	 * @param _description The _description to set.
	 */
	public void setDescription(String description) {
		_description.setText(description);
	}
	/**
	 * @return Returns the _name.
	 */
	public String getName() {
		return _name.getText();
	}
	/**
	 * @param _name The _name to set.
	 */
	public void setName(String name) {
		_name.setText(name);
	}
	/**
	 * @return Returns the _description.
	 */
	public Label getDescriptionLabel() {
		return _description;
	}
	/**
	 * @return Returns the _name.
	 */
	public Label getNameLabel() {
		return _name;
	}
}
