/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceUIImages.java,v 1.7 2006/10/03 19:13:56 nmehrega Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * Image manager for the Hyades Test UI plugin.
 */
public class TraceUIImages
extends ImageManager
{
	/**
	 * HyadesUIImages' singleton.
	 */
	public static final TraceUIImages INSTANCE = new TraceUIImages();
	
	/*
	 * Available cached Images in the Trace plugin image registry.
	 */
	
	/* obj16 */
	public static final String IMG_UNCHECKED 				= "blank_obj.gif";
	
	/* wizban */
	public static final String IMG_PROF_SET_WIZ_BAN			= "profset_wiz.gif";
	public static final String IMG_LOG_WIZ_BAN				= "log_wiz_ban.gif";
	
	/* clcl16 */
	public static final String IMG_TERMINATE				= "terminate_co.gif";
	public static final String IMG_REFRESH_VIEWS			= "updateviews_co.gif";
	public static final String IMG_RESUME					= "resume_co.gif";
	public static final String IMG_PAUSE					= "suspend_co.gif";
	public static final String IMG_DUMP						= "heap_start_co.gif";
	public static final String IMG_GC						= "rungc_co.gif";	
	public static final String IMG_ATTACH_AGENT             = "attachAgent.gif";
	public static final String IMG_DETACH_AGENT             = "detachAgent.gif";
	public static final String IMG_REFRESH_OPTIONS			= "message_options.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_OBJ, IMG_UNCHECKED);
		
		add(T_WIZBAN, IMG_PROF_SET_WIZ_BAN);
		add(T_WIZBAN, IMG_LOG_WIZ_BAN);
		
		add("c", T_LCL, IMG_TERMINATE);
		add("c", T_LCL, IMG_REFRESH_VIEWS);
		add("c", T_LCL, IMG_RESUME);
		add("c", T_LCL, IMG_PAUSE);
		add("c", T_LCL, IMG_DUMP);
		add("c", T_LCL, IMG_GC);
		add("c", T_LCL, IMG_ATTACH_AGENT);
		add("c", T_LCL, IMG_DETACH_AGENT);
		add("c", T_LCL, IMG_REFRESH_OPTIONS);
		
		add("d", T_LCL, IMG_TERMINATE);
		add("d", T_LCL, IMG_REFRESH_VIEWS);
		add("d", T_LCL, IMG_RESUME);
		add("d", T_LCL, IMG_PAUSE);
		add("d", T_LCL, IMG_DUMP);
		add("d", T_LCL, IMG_GC);		
		add("d", T_LCL, IMG_ATTACH_AGENT);
		add("d", T_LCL, IMG_DETACH_AGENT);
		add("d", T_LCL, IMG_REFRESH_OPTIONS);
		
	}	
}
