/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceViewOptionsUI.java,v 1.7 2006/12/29 19:16:45 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;

/**
 * The "Appearance" preference page under "Profiling and Logging". This
 * page gives the user the option to either display or not display project
 * folders in the Profiling Monitor view. If selected, they will appear in
 * both layouts.
 */
public class TraceViewOptionsUI {
	
	private Button _displayProjects;
	
	/**
	 * Creates the UI components for the preference page, in the given
	 * parent composite.
	 * 
	 * @param parent The parent composite that will contain the one being created.
	 * @return The newly created composite containing the UI components.
	 */
	public Composite createControl(Composite parent) {
		GridLayout layout;

		Group content = new Group(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		content.setLayout(layout);
		content.setLayoutData(GridUtil.createHorizontalFill());
		content.setText(UIPlugin.getResourceString(TraceMessages.PROF_LOG_GRP));

		_displayProjects = new Button(content, SWT.CHECK);
		_displayProjects.setText(UIPlugin.getResourceString(TraceMessages.PAP_PR));
		
		initializeValues();
		return content;
	}

	/**
	 * Initializes states of the controls from the preference store.
	 */
	public void initializeValues() {
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		_displayProjects.setSelection(store.getBoolean(CommonUITraceConstants.DISPLAY_PROJECTS));
	}

	/**
	 * Store the current values to the preference store.
	 */
	public void storeValues() {
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		store.setValue(CommonUITraceConstants.DISPLAY_PROJECTS, _displayProjects.getSelection());
	}
}