/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCMonitorEditor.java,v 1.7 2005/12/16 21:11:24 slavescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
* CONTEXT_ID mone0000 for Monitor Editor
*/

public class TRCMonitorEditor extends EditorPart {
	private TRCMonitor fMonitor;

	public TRCMonitorEditor() {
		super();
	}
	public void createPartControl(Composite parent) {
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			parent,
			UIPlugin.getPluginId() + ".mone0000");

		TraceLocationUI locationUI = new TraceLocationUI();
		locationUI.createControl(parent);
		locationUI.setEnabled(false);

		if (fMonitor == null)
			return;

		IPath path =
			new Path(TString.resourcePath(fMonitor.eResource().getURI()));
		locationUI.getLocation().setText(
			path.uptoSegment(path.segmentCount() - 1).toOSString());
		locationUI.getMonitor().setText(fMonitor.getName());
	}
	/**
	 */
	public void doSave(IProgressMonitor monitor) {
	}
	/**
	 */
	public void doSaveAs() {
	}
	/**
	 * Sets the cursor and selection state for this editor to the passage defined
	 * by the given marker.
	 *
	 * @param marker the marker
	 */
	public void gotoMarker(IMarker marker) {
	}
	/**
	 */
	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {

		if (input instanceof IFileEditorInput) {
			setSite(site);
			setInput(input);
			loadMonitorDoc();

			if (fMonitor != null)
				setPartName(fMonitor.getName());
			else
				setPartName("Unknown monitor");
		}
	}
	/**
	 * Returns whether the contents of this editor have changed since the last save
	 * operation.  If this value changes the part must fire a property listener 
	 * event with <code>PROP_DIRTY</code>.
	 * <p>
	 *
	 * @return <code>true</code> if the contents have been modified and need
	 *   saving, and <code>false</code> if they have not changed since the last
	 *   save
	 */
	public boolean isDirty() {
		return false;
	}
	/**
	 * Returns whether the "save as" operation is supported by this editor.
	 *
	 * @return <code>true</code> if "save as" is supported, and <code>false</code>
	 *  if "save as" is not supported
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}
	/**
	 * Returns whether the contents of this editor should be saved when the editor
	 * is closed.
	 *
	 * @return <code>true</code> if the contents of the editor should be saved on
	 *   close, and <code>false</code> if the contents are expendable
	 */
	public boolean isSaveOnCloseNeeded() {
		return false;
	}
	/**
	 * Returns the monitor.
	 */
	private TRCMonitor loadMonitorDoc() {
		if (fMonitor == null) {
			try {
				String name =
					((FileEditorInput) getEditorInput())
						.getFile()
						.getFullPath()
						.toString();

				ResourceSet resourceSet =
					UIPlugin.getDefault().getResourceSet();
				Resource res =
					resourceSet.getResource(
						SaveUtil.createURI("platform:/resource" + name),
						true);

				if (res == null)
					return fMonitor;

				Iterator it = res.getContents().iterator();
				while (it.hasNext()) {
					Object current = it.next();
					if (current instanceof TRCMonitor) {
						fMonitor = (TRCMonitor) current;
						break;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return fMonitor;
	}
	/**
	 * Asks this part to take focus within the workbench.
	 * <p>
	 * Clients should not call this method (the workbench calls this method at
	 * appropriate times).
	 * </p>
	 */
	public void setFocus() {

	}
	
	
	/**
	 * Invokes the unload method of the monitor resource when the editor is closed
	 * and when the user is not in the profiling perspective.
	 */
	public void dispose ()
	{		
		/* Ali M. -- Defect # 98155 If not in the profiling perspective, then unload the resource */
		String currentPerspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId(); 
		if (currentPerspective.equals(PDPerspective.ID_TRACE_PERSPECTIVE))
			return;
		fMonitor.eResource().unload();
	}
}
