/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TRCProcessEditor.java,v 1.6 2005/12/16 21:11:24 slavescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.editors;

import java.util.Iterator;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProcessUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
* CONTEXT_ID proe0000 for Process Editor
*/

public class TRCProcessEditor extends EditorPart {
	TRCProcessProxy fProcess;

	public TRCProcessEditor() {
		super();
	}
	public void createPartControl(Composite parent) {
		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			parent,
			UIPlugin.getPluginId() + ".proe0000");

		TraceProcessUI processUI = new TraceProcessUI();
		processUI.createControl(parent);

		processUI.getLocationUI().setEnabled(false);
		processUI.getLaunchProcessUI().enable(false);

		processUI.getProcessIdUI().setEnabled(false);
		processUI.getNodeNameUI().setEnabled(false);

		if (fProcess != null) {
			TRCNode fNode = fProcess.getNode();
			TRCMonitor fMonitor = fNode.getMonitor();

			IPath path =
				new Path(TString.resourcePath(fMonitor.eResource().getURI()));
			processUI.getLocationUI().getLocation().setText(
				path.uptoSegment(path.segmentCount() - 1).toOSString());
			processUI.getLocationUI().getMonitor().setText(fMonitor.getName());

			String name = fProcess.getName();
			processUI.getLaunchProcessUI().getClassUI().setText(name);
			processUI.getProcessIdUI().setText(
				String.valueOf(fProcess.getPid()));
			processUI.getNodeNameUI().setText(fNode.getName());

			if (fProcess.getClasspath() != null)
				processUI.getLaunchProcessUI().getClassPathUI().setText(
					fProcess.getClasspath());
		}
	}
	/**
	 * Saves the contents of this editor.
	 * <p>
	 * If the save is successful, the editor fires a property changed event 
	 * reflecting the new dirty state (<code>PROP_SAVE_NEEDED</code> property).
	 * </p>
	 * <p>
	 * This method is long-running; progress and cancellation are provided
	 * by the given progress monitor. 
	 * </p>
	 *
	 * @param monitor the progress monitor
	 */
	public void doSave(IProgressMonitor monitor) {
	}
	/**
	 * Saves the contents of this editor to another object.
	 * <p>
	 * Implementors are expected to open a "save as" dialog where the user will
	 * be able to select a new name for the contents. After the selection is made,
	 * the contents should be saved to that new name.  During this operation a
	 * <code>ProgressMonitorDialog</code> should be used to indicate progress.
	 * </p>
	 * <p>
	 * If the save is successful, the editor fires a property changed event 
	 * reflecting the new dirty state (<code>PROP_SAVE_NEEDED</code> property).
	 * </p>
	 */
	public void doSaveAs() {
	}
	/**
	 * Returns the input for this editor.  If this value changes the part must 
	 * fire a property listener event with <code>PROP_INPUT</code>.
	 *
	 * @return the editor input
	 */
	//public IEditorInput getEditorInput();
	/**
	 * Returns the site for this editor. The method is equivalent to 
	 * <code>(IEditorSite) getSite()</code>.
	 *
	 * @return the editor site
	 */
	//public IEditorSite getEditorSite();
	/**
	 * Sets the cursor and selection state for this editor to the passage defined
	 * by the given marker.
	 *
	 * @param marker the marker
	 */
	public void gotoMarker(IMarker marker) {
	}
	/**
	 * Initializes this editor with the given editor site and input.
	 * <p>
	 * This method is automatically called shortly after part construction; it marks
	 * the start of the part's lifecycle. The 
	 * {@link IWorkbenchPart#dispose IWorkbenchPart.dispose} method will be called 
	 * automically at the end of the lifecycle. Clients must not call this method.
	 * </p><p>
	 * Implementors of this method must examine the editor input object type to
	 * determine if it is understood.  If not, the implementor must throw
	 * a <code>PartInitException</code>
	 * </p>
	 * @param site the editor site
	 * @param input the editor input
	 * @exception PartInitException if this editor was not initialized successfully
	 */
	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {
		if (input instanceof IFileEditorInput) {
			setSite(site);
			setInput(input);
			loadProcessDoc();

			if (fProcess != null)
				setPartName(fProcess.getName() + "[" + fProcess.getPid() + "]");
		}
	}
	/**
	 * Returns whether the contents of this editor have changed since the last save
	 * operation.  If this value changes the part must fire a property listener 
	 * event with <code>PROP_DIRTY</code>.
	 * <p>
	 *
	 * @return <code>true</code> if the contents have been modified and need
	 *   saving, and <code>false</code> if they have not changed since the last
	 *   save
	 */
	public boolean isDirty() {
		return false;
	}
	/**
	 * Returns whether the "save as" operation is supported by this editor.
	 *
	 * @return <code>true</code> if "save as" is supported, and <code>false</code>
	 *  if "save as" is not supported
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}
	/**
	 * Returns whether the contents of this editor should be saved when the editor
	 * is closed.
	 *
	 * @return <code>true</code> if the contents of the editor should be saved on
	 *   close, and <code>false</code> if the contents are expendable
	 */
	public boolean isSaveOnCloseNeeded() {
		return false;
	}
	/**
	 * Returns the monitor.
	 */
	private TRCProcessProxy loadProcessDoc() {
		if (fProcess == null) {
			try {
				String name =
					((FileEditorInput) getEditorInput())
						.getFile()
						.getFullPath()
						.toString();

				ResourceSet resourceSet =
					UIPlugin.getDefault().getResourceSet();
				Resource res =
					resourceSet.getResource(
						SaveUtil.createURI("platform:/resource" + name),
						true);

				if (res == null)
					return fProcess;

				Iterator it = res.getContents().iterator();
				while (it.hasNext()) {
					Object current = it.next();
					if (current instanceof TRCProcessProxy) {
						fProcess = (TRCProcessProxy) current;
						break;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return fProcess;
	}
	/**
	 * Asks this part to take focus within the workbench.
	 * <p>
	 * Clients should not call this method (the workbench calls this method at
	 * appropriate times).
	 * </p>
	 */
	public void setFocus() {

	}
	
	
	/**
	 * Invokes the unload method of the monitor resource when the editor is closed
	 * and when the user is not in the profiling perspective.
	 */
	public void dispose ()
	{		
		/* Ali M. -- Defect # 98155 If not in the profiling perspective, then unload the resource */
		if (PDCoreUtil.isProfilingPerspective())
			return;
		fProcess.eResource().unload();
	}
}
