/**********************************************************************
 * Copyright (c) 2008 Intel Corporation.
 * All rights reserved. This content is made available under
 * the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html       
 * $Id: ExternalJavaArgumentsTab.java,v 1.1 2008/04/25 19:30:35 aalexeev Exp $
 *
 * Contributors:
 * Intel - Initial contribution
 **********************************************************************/ 

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;

public class ExternalJavaArgumentsTab extends JavaArgumentsTab {

	private boolean isValidated = true;
	
	public boolean isValid(ILaunchConfiguration config) {
		try {
			// directory shouldn't be validated if target host isn't localhost 
			if (config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME,
					CommonUITraceConstants.LOCAL_HOST).equals(CommonUITraceConstants.LOCAL_HOST)) {
				isValidated = true;
				return super.isValid(config);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		isValidated = false;
		return true;
	}
	
	public String getErrorMessage() {
		if (isValidated) {
			return super.getErrorMessage();
		} 
		return null;
	}
}
