/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExtendedProfilingType.java,v 1.2 2006/09/20 17:58:52 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;

/**
 * An extension to the Profiling Type interface which allows you to get the VM arguments of 
 * the given launch configuration.  Created for enhancement 143251.
 * @author Navid Mehregani
 * @deprecated The extension point org.eclipse.hyades.trace.ui.profilingTypes has been deprecated.  Use 
 * org.eclipse.hyades.trace.ui.analysisTypes in conjunction with org.eclipse.hyades.trace.ui.configurationWizard
 * instead.
 */
public interface IExtendedProfilingType extends IProfilingType {

	/**
	 * Returns the additional VM arguments that should be added to this launch configuration
	 * 
	 * @param conf  Launch configuration that's being used
	 * @return  The additional VM arguments to add to this launch configuration
	 */
	public String getVMArguments(ILaunchConfiguration conf);

}
