/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessWrapperRunnable.java,v 1.12 2007/05/19 00:52:01 jkubasta Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;

public class ProcessWrapperRunnable implements IRunnableWithProgress {

	private Object parent;

	private Object[] children = null;

	private ILaunchConfiguration _conf;

	private ArrayList fAgentTypeList;

	public ProcessWrapperRunnable(Object p_parent, ILaunchConfiguration c) {
		parent = p_parent;
		_conf = c;
		fAgentTypeList = null;
	}

	private ArrayList getAgentTypeList() {
		if (fAgentTypeList == null) {
			fAgentTypeList = new ArrayList();
			fAgentTypeList.add("Logging");
		}
		return fAgentTypeList;

	}

	private boolean isDisplay(Object obj) {
		if (obj instanceof Process) {
			Enumeration agents = ((Process) obj).listAgents();

			while (agents.hasMoreElements()) {
				if (isDisplay(agents.nextElement()))
					return true;
			}
			return false;
		} else if (obj instanceof Agent) {
			Agent agent = (Agent) obj;
			if (agent.isActive()) {
				if (agent.getType().equals(CommonUIConstants.LOG_AGENT_TYPE) && !agent.isAttached(true)) 
				{
					return true;
				} 
				else if (agent.getType().equals(CommonUIConstants.PROFILE_AGENT_TYPE)	&& !agent.isAttached(true)) 
				{
					return true;
				} 
				else 
				{
					ArrayList agentList = getAgentTypeList();
					for (int i = 0; i < agentList.size(); i++) {
						if (!(agent.getType()
								.equals(CommonUIConstants.LOG_AGENT_TYPE))
								&& (agent.getType().equals((String) (agentList
										.get(i))))) {
							return true;
						}
					}

				}
			}

			return false;
		}
		return true;
	}

	public void run(IProgressMonitor pm) {

		if (parent instanceof ProcessTreeItem) {
			ProcessTreeItem pti = (ProcessTreeItem) parent;

			if (pti.getData() == null) {
				List childrenList = new ArrayList();
				childrenList.addAll(AttachDelegate.retrieveProcesses(_conf, false).values());
				
				if (childrenList == null)
				{
					Vector childrenV = new Vector();
					childrenV.addElement(new ProcessTreeItem(new ErrorItem(TraceMessages.CONH_ERROR_), pti));
					children = childrenV.toArray();
					return;
				}
				
				Object[] childrenObjs = childrenList.toArray();
				
				if (childrenObjs.length == 0) {
					children = null;
				} else {
					Vector childrenV = new Vector();
					for (int i = 0; i < childrenObjs.length; i++) {
						if (isDisplay(childrenObjs[i]))
						{
							ProcessTreeItem processTreeItem = new ProcessTreeItem(childrenObjs[i], null);
							
							Process process = (Process) childrenObjs[i];
							Enumeration agents = process.listAgents();

							Vector agentsV = new Vector();

							while (agents.hasMoreElements()) {
								Object agent = agents.nextElement();
								if (isDisplay(agent))
									agentsV.addElement(new ProcessTreeItem(agent, processTreeItem));
							}							
							
							ProcessTreeItem[] agentsTreeItems = new ProcessTreeItem[agentsV.size()];
							agentsV.toArray(agentsTreeItems);
							
							processTreeItem.setChildren(agentsTreeItems);
							childrenV.addElement(processTreeItem);
						}
					}

					children = childrenV.toArray();
				}
			} else if (pti.getData() instanceof Process) {
				children = pti.getChildren();
			} else {
				children = null;
			}
		}
	}

	public Object[] getChildren() {
		if (children != null) {
			return children;
		}
		return new Object[0];
	}
}

