/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileDestinationTab.java,v 1.10 2007/05/19 00:52:45 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFileUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 * 
 * @deprecated Ali M. -- Clients are encouraged to use DestinationTab, which 
 * can be used to include as a separate configuraiton tab instead of a nested
 * tab.
 */
public class ProfileDestinationTab {
	
	private TraceLocationUI _destinationUI;
	private TraceFileUI _fileUI;
	private ProfileTab parentTab;
	
	public ProfileDestinationTab(ProfileTab pt)
	{
		_destinationUI = new TraceLocationUI();
		_fileUI = new TraceFileUI();
		parentTab = pt;
	}
	
	public Composite createControl(Composite parent)
	{
		
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout());
		content.setLayoutData(GridUtil.createFill());
		_destinationUI.createControl(content);

		_fileUI.createControl(content);
		
		

		if (!UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY))
			_fileUI.setVisible(false);

		
		return content;
		
		
	}
	
	public void addListener (Listener _listener)
	{
		_destinationUI.addListener(_listener);
		_fileUI.addListener(_listener);
	}
	
	public void activated(ILaunchConfigurationWorkingCopy conf)
	{
	}
	
	public void initializeFrom(ILaunchConfiguration conf)
	{
		try
		{
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
			String location = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, "");
			String monitor = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, "");
			String file = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, "");
			boolean profileToFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
			if (location.length() == 0) location = store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME);
			if (monitor.length() == 0) monitor = store.getString(CommonUITraceConstants.TRACE_MONITOR_NAME);
			
			_destinationUI.setLocation(location);
			_destinationUI.setMonitor(monitor);
			_fileUI.setFile(file);
			_fileUI.setEnabled(profileToFile);
			_fileUI.getExternalBox().setSelection(profileToFile);
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
	}
	
	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, _destinationUI.getLocation().getText().trim());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, _destinationUI.getMonitor().getText().trim());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, _fileUI.getExternalBox().getSelection());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, _fileUI.getFile());
	}
	
	public boolean isValid(ILaunchConfiguration conf)
	{
		parentTab.setErrorMessage(null);
		parentTab.setMessage(null);

		if (_destinationUI.getLocation().getText().trim().length() == 0)
		{
			parentTab.setErrorMessage(TraceMessages.TAB_ERRDP);
			return false;
		}

		if (_destinationUI.getMonitor().getText().trim().length() == 0)
		{
			parentTab.setErrorMessage(TraceMessages.TAB_ERRDM);
			return false;
		}

		if (_fileUI.getSelection() && _fileUI.getFile().trim().length() == 0)
		{
			parentTab.setErrorMessage(TraceMessages.TAB_ERRDF);
			return false;
		}
		
		if (_fileUI.getSelection() && _fileUI.getFile().trim().length() > 0)
		{
			String fName = _fileUI.getFile().trim();	
			String dirName = getDirectoryName(fName);
			String fileName = getFileName(fName);
					
			
			if (!(new File(dirName)).exists()){		
				parentTab.setErrorMessage(TraceMessages.TAB_ERRDR);
				return false;
			}		
			
			if (fileName.equals("")|| fileName.length() == 0){		
				parentTab.setErrorMessage(TraceMessages.TAB_ERRDR);
				return false;
			}
			
			if((new File(fName)).isDirectory()){
				parentTab.setErrorMessage(TraceMessages.TAB_ERRDR);
				return false;
			}				
		}	

		return true;
	}
	
	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(CommonUITraceConstants.TRACE_MONITOR_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null);
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
	}
	
	private String getDirectoryName(String fName) {
		int i = fName.lastIndexOf(File.separatorChar);
		if (i >= 0) {
			fName = fName.substring(0, i);
		}
		return fName;
	}
	
	private String getFileName(String fName) {
		int i = fName.lastIndexOf(File.separatorChar);
		if (i >= 0) {
			fName = fName.substring(i + 1);
		}
		return fName;
	}
}
