/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileEnvironmentTab.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.ui.EnvironmentTab;

/**
 * A customized Environment tab with the append/replace radio
 * buttons always disabled. The append button is always
 * selected. This is because only appending is supported for
 * profiling.
 */
public class ProfileEnvironmentTab extends EnvironmentTab {
	/*
	 * @see org.eclipse.debug.ui.EnvironmentTab#updateAppendReplace()
	 */
	protected void updateAppendReplace() {
		appendEnvironment.setEnabled(false);
		appendEnvironment.setSelection(true);
		replaceEnvironment.setEnabled(false);
		replaceEnvironment.setSelection(false);
	}
}
