/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileFiltersTab.java,v 1.9 2006/09/20 18:53:52 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;

import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;
/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfileFiltersTab {
	
	private TraceProfileFiltersUI _filtersUI;
			
	public ProfileFiltersTab(String parentName, ProfileTab pt)
	{
		_filtersUI = new TraceProfileFiltersUI();
	}
	
	public ProfileFiltersTab(String parentName)
	{
		_filtersUI = new TraceProfileFiltersUI();
	}
		
	public Composite createControl(Composite parent)
	{
		return _filtersUI.createControl(parent);
	}
	
	public void addListener (Listener _listener)
	{
		_filtersUI.addListener(_listener);
	}
	

	public String getName()
	{
		return TraceMessages.TB_NFILT;
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_FILTER);
	}
	
	public void activateFilters(FilterSetElement[] list, FilterSetElement selected)
	{
		FilterSetElement[] newList = order(list, selected);

		//sends the list fo the TraceProfileFiltersUI to populate it's table
		_filtersUI.reset();
		_filtersUI.addFilterSets(newList);
		_filtersUI.setActiveFilterSet(selected);
	}
	
	public String getActiveFilterSet() {
		return _filtersUI.getActiveFilterSet();
	}
	
	private FilterSetElement[] order(FilterSetElement[] list, FilterSetElement selected) {
		FilterSetElement[] ordered = new FilterSetElement[list.length];
		System.arraycopy(list, 0, ordered, 0, list.length);
		for (int i=0;i<ordered.length;++i) {
			if (ordered[i] == selected) {
				ordered[i] = ordered[0];
				ordered[0] = selected;
				break;
			}
		}
		return ordered;
	}
		
	public ArrayList getFilterSet()
	{
		return _filtersUI.getFilterSet();
	}
}
