/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileHostTab.java,v 1.19 2008/04/23 16:57:34 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITracePlugin;

public class ProfileHostTab extends AbstractLaunchConfigurationTab
{
	private TraceHostUI _ui;

	public void createControl(Composite parent)
	{
		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_ui = new TraceHostUI();
		_ui.createControl(content);
		_ui.addListener(new Listener()
		{
			public void handleEvent(Event event)
			{
				// the host changed; update
				updateLaunchConfigurationDialog();
				
				/*
				 * #63289: We have no way to know when the user clicked
				 * Apply. The only thing we can do is keep the preferences
				 * up to date as soon as user adds/deletes hosts.
				 */
				updatePreferences();
			}
		});
	}

	public boolean isValid(ILaunchConfiguration conf)
	{
		setErrorMessage(null);
		setMessage(null);

		if (_ui.getHost() == null)
		{
			setErrorMessage(TraceMessages.TAB_ERRHST);
			return false;
		}

		return true;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, CommonUITraceConstants.LOCAL_HOST);
	
		//if RAC is running , then set defect to RAC. else set to IAC
		boolean isRACrunning = false;
		
		// TODO NM 173330: wc.setAttribute might need to be changed
		
//		if(AgentControllerFactoryImpl.whoIsRunning() == AgentControllerConstants.TPTP_RAC_RUNNING) 
//		{
			isRACrunning = true;
//		}
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, isRACrunning? store.getDefaultInt(CommonUIConstants.LOCALHOST_PORT):-1);
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		try
		{
			String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, CommonUITraceConstants.LOCAL_HOST);
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, -1);
			String info = host + "[" + port + "]";

			_ui.addHost(info);
			_ui.selectHost(info);
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, _ui.getHost());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, _ui.getPort());
	}

	public String getName()
	{
		return TraceMessages.TAB_NHST;
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_NODE);
	}
	
	public boolean isLocal()
	{
		return ConnectUtil.isLocalHost(_ui.getHost());
	}
	
	private void updatePreferences()
	{
		IPreferenceStore store = CommonUITracePlugin.getDefault().getPreferenceStore();

		StringBuffer buf = new StringBuffer();
		
		TableItem[] items = _ui.getHosts();
		for(int idx=0; idx<items.length; idx++)	{
			buf.append(',');
			buf.append(items[idx].getText().trim());		
		}

		String hosts = buf.toString();
		if(hosts.startsWith(",") && hosts.length() > 1) {
			hosts = hosts.substring(1);
		}

		store.setValue(CommonUIConstants.HOST_KEY, hosts);
	}
}
