/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJUnitShortcut.java,v 1.14 2006/12/22 17:31:48 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;

public class ProfileJUnitShortcut extends JUnitLaunchShortcut {

	protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException
	{
		ILaunchConfigurationWorkingCopy configuration = super.createLaunchConfiguration(element);
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean autoFilteringCriteriaDefault = store.getBoolean(TraceConstants.AUTO_FILTER_CRITERIA_OPTION);
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_FILTER_CRITERIA, autoFilteringCriteriaDefault);
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, manager.getDefaultSet() == null ? null : manager.getDefaultSet().getId());
		configuration.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, autoFilteringCriteriaDefault ? TraceConstants.AUTO_GENERATED_FILTER_SET : LauncherConstants.DEFAULT_FILTER_ID);
		return configuration;
	}
}
