/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJavaApplicationDelegate.java,v 1.15 2008/03/11 18:47:26 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;


/**
 * @deprecated This delgate class is no longer used and should be removed.
 * Replacement is PIJavaApplicationDelegate
 */
public class ProfileJavaApplicationDelegate extends AbstractJavaLaunchConfigurationDelegate {

	public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.beginTask("", 4);
			monitor.subTask(TraceMessages.LNCH_MSGV);
			boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
			monitor.worked(1);
			
			if (!success) {
				monitor.setCanceled(true);
				return;
			}
	
			ProfilingSetsManager manager = ProfilingSetsManager.instance();
			IPreferenceStore store = CommonUIPlugin.getDefault().getPreferenceStore();
	
			TraceArguments args = new TraceArguments(getMainTypeName(conf));
			args.setClassPath(getClasspathString(conf));
			args.setParameters(getProgramArguments(conf));
			args.setVMArguments(getVMArguments(conf));
			args.setEnvironmentVariable(ProfileLaunchUtil.getEnvironmentVariables(conf));
			args.setAutoMonitoring(manager.getAutoMonitoring(conf));
			
			File workingDir = getWorkingDirectory(conf);
			if (workingDir != null) {
				args.setLocation(workingDir.getAbsolutePath());
			}
			else
			{
				args.setLocation(System.getProperty("user.dir"));
			}
			
			monitor.worked(1);
			
			String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, CommonUITraceConstants.LOCAL_HOST);			
			int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(CommonUIConstants.LOCALHOST_PORT));
			
			String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));
			String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(CommonUITraceConstants.TRACE_MONITOR_NAME));
	
			args.setHostName(hostName);
			args.setPortNumber(port);
	
			if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				args.setProfileFile(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null));
			else
				args.setProfileFile((String)null);
	
			ArrayList filters = manager.getFilters(conf);
			Vector options = manager.getOptions(conf);
			monitor.worked(1);
			
			if (!PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch)) {
				monitor.setCanceled(true);
			}
			monitor.worked(1);
		}
		catch (CoreException e) {
			monitor.setCanceled(true);
			throw e;
		}
	}

	private String getClasspathString(ILaunchConfiguration conf) throws CoreException {
		String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, (String) null);

		if (classPath == null) {
			StringBuffer buf = new StringBuffer();
			String[] entries = getClasspath(conf);
			for (int i = 0; i < entries.length - 1; ++i) {
				buf.append(entries[i]);
				buf.append(File.pathSeparatorChar);
			}
			buf.append(entries[entries.length - 1]);
			return buf.toString();
		}
		else {
			return classPath;
		}
	}
}
