/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJavaApplicationShortcut.java,v 1.12 2010/05/31 20:59:06 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaApplicationLaunchShortcut;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ProfileJavaApplicationShortcut extends JavaApplicationLaunchShortcut {

	/*
	 * @see org.eclipse.jdt.internal.debug.ui.launcher.JavaApplicationLaunchShortcut#launch(org.eclipse.jdt.core.IType, java.lang.String)
	 */
	protected void launch(IType type, final String mode) {
		ILaunchConfigurationType configType = getConfigurationType();
		ILaunchConfiguration config = findLaunchConfiguration(type, configType);
		
		// Bug 303965: Create a configuration if none currently exists
		if( null == config ) {
			config = createConfiguration(type);
		}
		
		final ILaunchConfiguration finalConfig = config;
		if (finalConfig != null) {
			Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					Shell shell = UIPlugin.getActiveWorkbenchShell();

					int result = DebugUITools.openLaunchConfigurationPropertiesDialog(shell, finalConfig, IDebugUIConstants.ID_PROFILE_LAUNCH_GROUP, new Status(Status.OK, UIPlugin.getPluginId(), RunLaunchProfileStatusHandler.CODE, "", null));
					if (result == Window.OK) {
						DebugUITools.launch(finalConfig, mode);
					}
				}
			});
		}
	}
	

	/**
	 * Show a selection dialog that allows the user to choose one of the specified
	 * launch configurations.  Return the chosen config, or <code>null</code> if the
	 * user cancelled the dialog.
	 */
	protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
		if (mode.equals(ILaunchManager.PROFILE_MODE)) {
			IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
			ElementListSelectionDialog dialog= new ElementListSelectionDialog(getShell(), labelProvider);
			dialog.setElements(configList.toArray());
			dialog.setTitle(TraceMessages.LSH_SCFT); 
			dialog.setMessage(TraceMessages.LSH_SCFM); 
			dialog.setMultipleSelection(false);
			int result = dialog.open();
			labelProvider.dispose();
			if (result == Window.OK) {
				return (ILaunchConfiguration) dialog.getFirstResult();
			}
			return null;
		}
		else {
			return super.chooseConfiguration(configList);
		}
	}

	protected ILaunchConfiguration createConfiguration(IType type) {
		return LauncherUtility.addExtendedConfigurationDefaults(super.createConfiguration(type));
	}
}
