/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJavaApplicationTabGroup.java,v 1.9 2010/08/22 22:10:12 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;

public class ProfileJavaApplicationTabGroup extends AbstractLaunchConfigurationTabGroup
{
		
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		ArrayList<ILaunchConfigurationTab> tabs = new ArrayList<ILaunchConfigurationTab>(10);
		
		tabs.add(new JavaMainTab());
		tabs.add(new JavaArgumentsTab());
		tabs.add(new JavaClasspathTab());
		tabs.add(new ProfileExtendedTab(false));
		tabs.add(new DestinationTab());
		tabs.add(new SourceLookupTab());
		tabs.add(new ProfileEnvironmentTab());
		tabs.add(new CommonTab());

		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(tabs, ProfileJavaApplicationTabGroup.class);
		
		ILaunchConfigurationTab[] array = new ILaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);
		setTabs(array);
	}
}

