/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileJavaProcessTabGroup.java,v 1.8 2010/08/22 22:10:12 jwest Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;

/**
 * @author znensi
 */
public class ProfileJavaProcessTabGroup extends AbstractLaunchConfigurationTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		ArrayList tabs = new ArrayList(10);

		// agents tab is context sensitive; depends on host
		tabs.add(new ProfileHostTab());
//		tabs.add(agents);
		tabs.add(new AttachAgentsTab());
//		tabs.add(new ProfileTab(true, false));
		tabs.add(new DestinationTab());
		tabs.add(new CommonTab());

		// Provide profiling dialogue tab list to interested extensions (Bug 323330)
		HyadesTraceUIExtensionSupportUtil.addOrInformExtensionTabs(tabs, ProfileJavaProcessTabGroup.class);
		
		AbstractLaunchConfigurationTab[] array = new AbstractLaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);
		setTabs(array);
	}
}
