/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileTab.java,v 1.20 2010/09/08 15:20:51 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.ui.PlatformUI;

public class ProfileTab extends AbstractLaunchConfigurationTab
{
	private TraceProfileUI _profileUI;
	
	private boolean includeDestinationTab;

	public ProfileTab()
	{
		this (true);
	}
	
	public ProfileTab(boolean includeDestinationTab)
	{
		this.includeDestinationTab = includeDestinationTab;
	}
	
	public void update()
	{
		updateLaunchConfigurationDialog();
	}


	public void createControl(Composite parent)
	{
		Composite content = new Composite(parent, SWT.NULL);
		setControl(content);
		content.setLayout(new GridLayout());
		
		
		_profileUI = new TraceProfileUI(this, includeDestinationTab);
		_profileUI.createControl(content);
		
		
		_profileUI.addListener(new Listener() {
					public void handleEvent(Event event)
					{
						// the values changed; update
						updateLaunchConfigurationDialog();
					}
				});
			
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, UIPlugin.getPluginId() + ".pcwp0000");
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		
		// Limits sub-tab defaults
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean(TraceConstants.LIMIT_TRACE_INVOC_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt(TraceConstants.LIMIT_INVOC_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean(TraceConstants.LIMIT_TRACE_TIME_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt(TraceConstants.LIMIT_TIME_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean(TraceConstants.PROF_AUTO_MONITOR));

		// Destination sub-tab defaults
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(CommonUITraceConstants.TRACE_PROJECT_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(CommonUITraceConstants.TRACE_MONITOR_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null);
		
		// Overview sub-tab defaults
		ProfilingSetsManager manager = ProfilingSetsManager.instance();
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, manager.getDefaultSet() == null ? null : manager.getDefaultSet().getId());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET, LauncherConstants.DEFAULT_FILTER_ID);
	}
	
	public void activated(ILaunchConfigurationWorkingCopy conf)
	{
		super.activated(conf);
		_profileUI.activated(conf);
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		_profileUI.initializeFrom(conf);
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		_profileUI.performApply(wc);
	}

	public void deactivated(ILaunchConfigurationWorkingCopy wc)
	{
		_profileUI.deactivated(wc);
	}
	
	public boolean isValid(ILaunchConfiguration conf)
	{
		boolean isValid = _profileUI.isValid(conf);
		if (!isValid)
			super.setErrorMessage(_profileUI.getErrorMessage());
		else
			super.setErrorMessage(null);
		return isValid;
	}

	public String getName()
	{
		return TraceMessages.TB_NPROF;
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_PROFILE_TAB);
	}
	
	public void setErrorMessage(String msg)
	{
		super.setErrorMessage(msg);
	}
	
	public void setMessage(String msg)
	{
		super.setMessage(msg);
	}

	public TraceProfileUI getProfileUI() {
		return _profileUI;
	}
	
}

