/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingSet.java,v 1.5 2006/05/11 15:05:07 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.*;
import java.util.Map;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;

/**
 * @deprecated Contributors should refrain from using profiling sets.  The concept along with all
 * associated APIs of profiling sets is deprecated since TPTP v4.2
 */
public class ProfilingSet implements IProfilingSet{
	
	protected String id;
	protected String name;
	protected String description;
	protected List profilingTypes = new ArrayList();
	protected Map attributes = new HashMap();
	private String displayName;
	private String displayDescription;
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * Returns the description to be displayed to the user. For default profiling sets which
	 * need to be translated properly, this will lookup the appropriate property key in the
	 * resource bundles.
	 * 
	 * @return the description to be displayed to the user, translated if this is a default set.
	 */
	public String getDisplayDescription() {
		if (description != null) {
			return description;
		}
		else if (displayDescription == null) {
			IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.PLUGIN_ID, "profilingSets");
			if (point != null) {
				IConfigurationElement[] elements = point.getConfigurationElements();
				for (int i=0;i<elements.length;i++) {
					IConfigurationElement elem = elements[i];
					if (id.equals(elem.getAttribute("id"))) {
						displayDescription = elem.getAttribute("description");
						break;
					}
				}
			}
		}
		return displayDescription;
	}
	/**
	 * Returns the profiling set name to be displayed to the user. For default profiling sets,
	 * which must be translated properly, this will lookup the appropriate property key in the
	 * resource bundles.
	 * 
	 * @return the name to be displayed to the user, translated if this is a default set.
	 */
	public String getDisplayName() {
		if (name != null) {
			return name;
		}
		else if (displayName == null) {
			IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.PLUGIN_ID, "profilingSets");
			if (point != null) {
				IConfigurationElement[] elements = point.getConfigurationElements();
				for (int i=0;i<elements.length;i++) {
					IConfigurationElement elem = elements[i];
					if (id.equals(elem.getAttribute("id"))) {
						displayName = elem.getAttribute("name");
						break;
					}
				}
			}
		}
		return displayName;
	}
	/**
	 * Returns the name field for this profiling set, unless it is a default set which should
	 * be translated, in which case it returns null. This is how the system knows whether it
	 * should lookup the translated default name.. if the user modifies the name, this field
	 * will be populated and will be used from then on. If this is a string that will be seen
	 * by the user, you should use getDisplayName() instead.
	 * 
	 * @return the profiling set name field, which is null if this is a default name to be translated
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the attributes.
	 */
	public Map getAttributes() {
		return attributes;
	}
	/**
	 * @param attributes The attributes to set.
	 */
	public void setAttributes(Map attributes) {
		this.attributes = attributes;
	}
	/**
	 * @return Returns the profilingTypes.
	 */
	public List getProfilingTypes() {
		return profilingTypes;
	}
	/**
	 * @param profilingTypes The profilingTypes to set.
	 */
	public void setProfilingTypes(List profilingTypes) {
		this.profilingTypes = profilingTypes;
	}
	/**
	 * Returns the description field for this profiling set, unless it is a default set which
	 * should be translated, in which case it returns null. This is how the system knows whether
	 * it should lookup the translated default description.. if the user modifies the name, this
	 * field will be populated and will be used from then on. If this is a string that will be seen
	 * by the user, you should use getDisplayDescription() instead.
	 * 
	 * @return the description field, which is null if this is a default description to be translated
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @param id
	 * @param name
	 * @param description
	 */
	public ProfilingSet(String id, String name, String description) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
	}
}
