/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingSetType.java,v 1.4 2006/05/11 15:05:07 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * @deprecated Contributors should refrain from using profiling sets or any related API.  The concept along 
 * with associated APIs of profiling sets is deprecated since TPTP v4.2
 */
public class ProfilingSetType implements IProfilingSetType{
	
	protected String id;
	protected String name;
	protected String description;
	protected ImageDescriptor image;
	protected boolean useFilters;
	protected String group;	
	protected IProfilingType profilingType;
	
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the image.
	 */
	public ImageDescriptor getImage() {
		return image;
	}
	/**
	 * @param image The image to set.
	 */
	public void setImage(ImageDescriptor image) {
		this.image = image;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return Returns the profilingType.
	 */
	public IProfilingType getProfilingType() {
		return profilingType;
	}
	/**
	 * @param profilingType The profilingType to set.
	 */
	public void setProfilingType(IProfilingType profilingType) {
		this.profilingType = profilingType;
	}
	/**
	 * @return Returns the useFilters.
	 */
	public boolean isUseFilters() {
		return useFilters;
	}
	/**
	 * @param useFilters The useFilters to set.
	 */
	public void setUseFilters(boolean useFilters) {
		this.useFilters = useFilters;
	}
	/**
	 * @param id
	 * @param name
	 * @param description
	 * @param image
	 * @param useFilters
	 * @param group
	 * @param profilingType
	 */
	public ProfilingSetType(String id, String name, String description,
			ImageDescriptor image, boolean useFilters, String group,
			IProfilingType profilingType) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.image = image;
		this.useFilters = useFilters;
		this.group = group;
		this.profilingType = profilingType;
	}
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return Returns the group.
	 */
	public String getGroup() {
		return group;
	}
	/**
	 * @param group The group to set.
	 */
	public void setGroup(String group) {
		this.group = group;
	}
	
	
	/**
	 * Ali M.: -- Compares this object with the passed object and returns true iff the
	 * passed object is of type IProfilingSetType and has the same ID.
	 * 
	 * @param obj The object that will be compared with this object
	 * @return True if this object is equalled to this object
	 */
	public boolean equals(Object obj) 
	{
		if (obj instanceof IProfilingSetType)
			return id != null && id.equals(((IProfilingSetType)obj).getId());					
		return false;
	}
}
