/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RunAttachProfileStatusHandler.java,v 1.3 2007/05/19 00:58:28 jkubasta Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;

public class RunAttachProfileStatusHandler implements IStatusHandler {

	public static int CODE = 2000;
	
	public Object handleStatus(IStatus status, Object source) {
		ILaunchConfigurationDialog dialog = (ILaunchConfigurationDialog)source;
		Object [] tabs = dialog.getTabs();
		if (tabs != null)
		{
			for (int i = 0; i < tabs.length; i++)
			{
				if (tabs[i] instanceof AttachAgentsTab)
				{
					dialog.setActiveTab(i);
					return null;
				}
			}
		}

		return null;
	}
}
