/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SelectedAgent.java,v 1.1 2007/04/18 15:23:40 amehregani Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.StringTokenizer;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;


public class SelectedAgent
{
	private String pid;
	private String agentName;
	private String collectorId;
	private String[] analysisTypes;
	private Agent agent;
	private IAgent newAgent;
	
	public SelectedAgent(String pid, String agentName, String dataCollector, String[] analysisTypes)
	{
		this.pid = pid;
		this.agentName = agentName;
		this.collectorId = dataCollector;
		this.analysisTypes = analysisTypes;
	}
	
	public SelectedAgent(String agentSelectionString)
	{
		StringTokenizer tok = new StringTokenizer(agentSelectionString, ":"); //$NON-NLS-1$
		
		if (tok.countTokens() < 3)
			return;
		
		pid = tok.nextToken().trim();		
		agentName = tok.nextToken().trim();
		collectorId = tok.nextToken().trim();
		
		if (tok.hasMoreTokens())
		{
			StringTokenizer analysisTypes = new StringTokenizer(tok.nextToken(), ","); //$NON-NLS-1$
			this.analysisTypes = new String[analysisTypes.countTokens()];
			
			for (int i = 0; i < this.analysisTypes.length; i++)
			{
				this.analysisTypes[i] = analysisTypes.nextToken().trim();
			}
		}
	}

	
	/**
	 * @return the pid
	 */
	public String getPid()
	{
		return pid;
	}

	/**
	 * @param pid the pid to set
	 */
	public void setPid(String pid)
	{
		this.pid = pid;
	}

	/**
	 * @return the collectorId
	 */
	public String getCollectorId()
	{
		return collectorId;
	}

	/**
	 * @param collectorId the collectorId to set
	 */
	public void setCollectorId(String collectorId)
	{
		this.collectorId = collectorId;
	}

	/**
	 * @return the analysisTypes
	 */
	public String[] getAnalysisTypes()
	{
		return analysisTypes;
	}

	/**
	 * @param analysisTypes the analysisTypes to set
	 */
	public void setAnalysisTypes(String[] analysisTypes)
	{
		this.analysisTypes = analysisTypes;
	}

	/**
	 * @return the agentName
	 */
	public String getAgentName()
	{
		return agentName;
	}

	/**
	 * @param agentName the agentName to set
	 */
	public void setAgentName(String agentName)
	{
		this.agentName = agentName;
	}

	/**
	 * @return the agent
	 */
	public Agent getAgent()
	{
		return agent;
	}

	/**
	 * @param agent the agent to set
	 */
	public void setAgent(Agent agent)
	{
		this.agent = agent;
	}

	/**
	 * @return the newAgent
	 */
	public IAgent getNewAgent()
	{
		return newAgent;
	}

	/**
	 * @param newAgent the newAgent to set
	 */
	public void setNewAgent(IAgent newAgent)
	{
		this.newAgent = newAgent;
	}
	
	
}
