/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionTimeProfilingType.java,v 1.4 2005/06/27 18:54:16 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 */
public class ExecutionTimeProfilingType implements IProfilingType {
	
	private ExecutionTimeUI _optionsUI;		//the UI asociated with this type
	private Control control;				//the control from the UI
	private String description;
	
	public ExecutionTimeProfilingType()
	{
		_optionsUI = new ExecutionTimeUI();
	}
	
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config)
	{
		control =  _optionsUI.createControl(parent);
		initializeValues(config);
		
		return control;
	}
	
	protected void initializeValues(ProfilingSetsManagerCopy config)
	{
		Map configAttributes = config.getDefaultSet().getAttributes();
		//sets the attributes based on the config
		//if they haven't been stored yet, then use the default I specify
		String prefix = "SETOPTION_";		
		Object option = configAttributes.get(prefix+Options.OPTION_BOUNDARY_DEPTH);
		if(option == null)
		{
			_optionsUI.setCollectionDepth("1");			
		}
		else
		{
			_optionsUI.setCollectionDepth(((ProfilingAttribute)option).getValue());
			_optionsUI.setExecutionBoundary(true);
		}
		
		option = configAttributes.get(prefix+Options.OPTION_CPU_TIME);
		if(option != null)
		{
			String cpuTimeValue = ((ProfilingAttribute)option).getValue();
			_optionsUI.setCPUtime("true".equalsIgnoreCase(cpuTimeValue));
		}
		
		option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW);
		if(option == null)
		{
			_optionsUI.setExecutionFlow(false);
			_optionsUI.setExecutionStatistic(!_optionsUI.getExecutionFlow());
			
		}
		else
		{
			_optionsUI.setExecutionFlow(((ProfilingAttribute)option).getValue().equalsIgnoreCase("true"));
			_optionsUI.setExecutionStatistic(!_optionsUI.getExecutionFlow());
			
		}
		
		option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES);
		if(option != null)
		{
			String instanceValue = ((ProfilingAttribute)option).getValue();
			_optionsUI.setInstance("true".equalsIgnoreCase(instanceValue));
		}
				
		_optionsUI.enableButtons();
				
		//storeValues();
	}
	
	
	public Control getControl(String profilingSetName)
	{
		return control;
	}
	
	public ProfilingAttribute[] getAttributes()
	{
		//map my UI options to options for the RAC
		//to be recognized as RAC options, the name should be prefixed by SETOPTION_
		String prefix = "SETOPTION_";		
		List options = new ArrayList();
		
		if (_optionsUI.getExecutionBoundary())
		{
			String[][] optionSet = null;
			if (_optionsUI.getInstance()) {
				optionSet = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY_INSTANCES;
			}
			else {
				optionSet = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
			}

			for (int idx = 0; idx < optionSet.length; idx++) {				
				options.add(new ProfilingAttribute(prefix+optionSet[idx][0], optionSet[idx][1]));
			}
			
			//add boundary depth
			options.add(new ProfilingAttribute(prefix+Options.OPTION_BOUNDARY_DEPTH, String.valueOf(_optionsUI.getCollectionDepth())));
		}
		else
		{
			String[][] optionSet = null;
			if (_optionsUI.getInstance()) {
				optionSet = Options.OPTIONS_EXECUTION_FLOW_INSTANCES;
			}
			else {
				optionSet = Options.OPTIONS_EXECUTION_FLOW;
			}
			
			for (int idx = 0; idx < optionSet.length; idx++) {
				options.add(new ProfilingAttribute(prefix+optionSet[idx][0], optionSet[idx][1]));
			}		
		}

		String flow = String.valueOf(_optionsUI.getExecutionFlow());  //determine full or compressed
		options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, flow));
		String showHeap = String.valueOf(_optionsUI.getInstance());   //determine collect instance
		options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, showHeap));

		if (_optionsUI.getCPUtime()==true) {
			String[][] optionSet = Options.OPTIONS_COLLECT_CPU_TIME;
			
			for (int idx = 0; idx < optionSet.length; idx++) {
				options.add(new ProfilingAttribute(prefix+optionSet[idx][0], optionSet[idx][1]));
			}		
		}
		
		ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
		options.toArray(pOptions);
		return pOptions;
	}
	
	/**
	 * Returns a not null error message is the current configuration is not valid
	 * This method is called when the current configuration is updated, for example when
	 * the user updates the profiling options for the current filter set 
	 * performApply is called next if this method returns a null value for all selected 
	 * profiling types
	 * 
	 * @param managerCopy a temporary copy for the current configuration
	 * @return null if the configuration is valid and can be applied
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy)
	{
		return null;
	}

	/**
	 * This method is called from the launch configuration, prior to launching the application
	 * If the method returns a not null string, an error message will be displayed and the
	 * launch configuration aborts
	 * @param config
	 * @return
	 */	
	public String launch(ILaunchConfiguration config)
	{
		return null;
    }
	
	public String getDescription(ProfilingSetsManagerCopy managerCopy)
	{
		return description;
	}
}
