/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MemoryHeapProfilingType.java,v 1.2 2005/02/25 22:17:19 hleung Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.*;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.launcher.*;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 */
public class MemoryHeapProfilingType implements IProfilingType {
	
	private MemoryHeapUI _optionsUI;
	private Control control;
	private String description;
	
	public MemoryHeapProfilingType()
	{
		_optionsUI = new MemoryHeapUI();
	}
	
	public Control createControl(Composite parent, ProfilingSetsManagerCopy config)
	{
		control =  _optionsUI.createControl(parent);		
		initializeValues(config);
		
		return control;
	}
	
	protected void initializeValues(ProfilingSetsManagerCopy config)
	{
		Map configAttributes = config.getDefaultSet().getAttributes();
		
		//sets the attributes based on the config
		Object option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES);
		if(option != null)
		{
			String instanceValue = ((ProfilingAttribute)option).getValue();
			_optionsUI.setHeapDetails("true".equalsIgnoreCase(instanceValue));			
		}
	}
	
	public Control getControl(String profilingSetName)
	{
		return control;
	}
	
	public ProfilingAttribute[] getAttributes()
	{
		//map my UI options to options for the RAC
		//to be recognized as RAC options, the name should be prefixed by SETOPTION_	
		String prefix = "SETOPTION_";				
		List options = new ArrayList();
		
		String[][] heapData = Options.OPTIONS_ANALYZE_HEAP;		
		for (int idx = 0; idx < heapData.length; idx++) {
			options.add(new ProfilingAttribute(prefix+heapData[idx][0], heapData[idx][1]));
		}
		
		String showHeap = String.valueOf(_optionsUI.getHeapDetails());
		options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, showHeap));
		
		ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
		options.toArray(pOptions);
		return pOptions;
	}
	
	/**
	 * Returns a not null error message is the current configuration is not valid
	 * This method is called when the current configuration is updated, for example when
	 * the user updates the profiling options for the current filter set 
	 * performApply is called next if this method returns a null value for all selected 
	 * profiling types
	 * 
	 * @param managerCopy a temporary copy for the current configuration
	 * @return null if the configuration is valid and can be applied
	 */
	public String validateConfiguration(ProfilingSetsManagerCopy managerCopy)
	{
		return null;
	}

	/**
	 * This method is called from the launch configuration, prior to launching the application
	 * If the method returns a not null string, an error message will be displayed and the
	 * launch configuration aborts
	 * @param config
	 * @return
	 */	
	public String launch(ILaunchConfiguration config)
	{
		return null;
	}
	
	
	public String getDescription(ProfilingSetsManagerCopy managerCopy)
	{
		return description;
	}
	
}
