/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MemoryHeapUI.java,v 1.11 2005/08/09 02:48:50 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;


import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;


public class MemoryHeapUI implements SelectionListener
{
	
	private Composite _detailsHeapGroup;
	private Button _showHeapInstance;
	
	private Label titleLabel;
	private Label optionsLabel;
	private Button _advancedOptions;
	private Composite _heapOptionGrp;
	

	public MemoryHeapUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		result.setLayout(layout);
		result.setLayoutData(data);
		
		titleLabel = new Label(result, SWT.NULL);
		titleLabel.setText(UIPlugin.getResourceString("memoryType"));
		titleLabel.setLayoutData(GridUtil.createHorizontalFill());

		Font font = titleLabel.getFont();
		if (font != null) {
			FontData[] fonts = font.getFontData();
			if (fonts != null && fonts.length >= 1) {
				titleLabel.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
			}
		}

		new Label(result, SWT.NULL);

		optionsLabel = new Label(result, SWT.WRAP);
		optionsLabel.setText(TraceMessages.ANHEAP);
		data = new GridData();
		data.horizontalIndent = 20;
		data.widthHint = 375;
		optionsLabel.setLayoutData(data);


		Composite grp = new Composite(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		layout = new GridLayout();
		layout.numColumns = 1;
		grp.setLayout(layout);
		grp.setLayoutData(data);
		
		addHeapOption(grp);
		_detailsHeapGroup.setVisible(true);

		return result;
	}

	private void addHeapOption(Composite parent) {
		GridLayout layout;
		GridData data;

		_detailsHeapGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
		_detailsHeapGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_detailsHeapGroup.setLayout(layout);

		_advancedOptions = new Button(_detailsHeapGroup, SWT.PUSH);
		_advancedOptions.setText(TraceMessages.ADV_BTN);
		_advancedOptions.addSelectionListener(this);

		_heapOptionGrp = new Composite(_detailsHeapGroup, SWT.NULL);
		_heapOptionGrp.setLayout(new GridLayout());
		
		_showHeapInstance = new Button(_heapOptionGrp, SWT.CHECK);
		_showHeapInstance.setText(
				TraceMessages.SH_INSTLI);						
		
		Label info = new Label(_heapOptionGrp, SWT.WRAP);
		data = new GridData();
		data.widthHint = 375;		
		info.setLayoutData(data);
		info.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
		info.setText(TraceMessages.INSTL_INFO);
		
		_heapOptionGrp.setVisible(false);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(
			_showHeapInstance,
			UIPlugin.getPluginId() + ".topp0011");
	}

	public void enableButtons() {

		enableBtnGroup();
	}

	public void enableBtnGroup() {
		enableHeptBtnGroup();
	}

	private void enableHeptBtnGroup() {
		_showHeapInstance.setEnabled(true);
		_advancedOptions.setEnabled(true);		
	}
	
	public void enableHeapInfo(boolean enable) {

		if (!enable) {
			_advancedOptions.setEnabled(false);
			_showHeapInstance.setEnabled(false);
		}
	}
	
	public boolean getHeapDetails() {
		return _showHeapInstance.getSelection();
	}

	public void setHeapDetails(boolean setValue) {
		_showHeapInstance.setSelection(setValue);
	}
	
	public void widgetDefaultSelected(SelectionEvent event) {
	}

	public void widgetSelected(SelectionEvent event) {
		if (event.widget == _advancedOptions) {
			_heapOptionGrp.setVisible(!_heapOptionGrp.getVisible());
		}
	}
	
}
